/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider.symmetric;

import cn.tca.TopBasicCrypto.asn1.kisa.KISAObjectIdentifiers;
import cn.tca.TopBasicCrypto.crypto.CipherKeyGenerator;
import cn.tca.TopBasicCrypto.crypto.engines.SEEDEngine;
import cn.tca.TopBasicCrypto.crypto.engines.SEEDWrapEngine;
import cn.tca.TopBasicCrypto.crypto.modes.CBCBlockCipher;
import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher;
import cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters;
import cn.tca.TopBasicCrypto.jce.provider.WrapCipherSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.spec.IvParameterSpec;

public final class SEED {
    private SEED() {
    }

    public static class Mappings
    extends HashMap {
        public Mappings() {
            this.put("AlgorithmParameters.SEED", "cn.tca.TopBasicCrypto.jce.provider.symmetric.SEED$AlgParams");
            this.put("Alg.Alias.AlgorithmParameters." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            this.put("AlgorithmParameterGenerator.SEED", "cn.tca.TopBasicCrypto.jce.provider.symmetric.SEED$AlgParamGen");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            this.put("Cipher.SEED", "cn.tca.TopBasicCrypto.jce.provider.symmetric.SEED$ECB");
            this.put("Cipher." + KISAObjectIdentifiers.id_seedCBC, "cn.tca.TopBasicCrypto.jce.provider.symmetric.SEED$CBC");
            this.put("Cipher.SEEDWRAP", "cn.tca.TopBasicCrypto.jce.provider.symmetric.SEED$Wrap");
            this.put("Alg.Alias.Cipher." + KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, "SEEDWRAP");
            this.put("KeyGenerator.SEED", "cn.tca.TopBasicCrypto.jce.provider.symmetric.SEED$KeyGen");
            this.put("KeyGenerator." + KISAObjectIdentifiers.id_seedCBC, "cn.tca.TopBasicCrypto.jce.provider.symmetric.SEED$KeyGen");
            this.put("KeyGenerator." + KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, "cn.tca.TopBasicCrypto.jce.provider.symmetric.SEED$KeyGen");
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "SEED IV";
        }
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SEED parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("SEED", BouncyCastleProvider.PROVIDER_NAME);
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            super("SEED", 128, new CipherKeyGenerator());
        }
    }

    public static class Wrap
    extends WrapCipherSpi {
        public Wrap() {
            super(new SEEDWrapEngine());
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SEEDEngine()), 128);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new SEEDEngine());
        }
    }
}

