/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.apache.bzip2.CBZip2InputStream;
import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.bcpg.CompressedDataPacket;
import cn.tca.TopBasicCrypto.bcpg.CompressionAlgorithmTags;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PGPCompressedData
implements CompressionAlgorithmTags {
    CompressedDataPacket data;

    public PGPCompressedData(BCPGInputStream pIn) throws IOException {
        this.data = (CompressedDataPacket)pIn.readPacket();
    }

    public int getAlgorithm() {
        return this.data.getAlgorithm();
    }

    public InputStream getInputStream() {
        return this.data.getInputStream();
    }

    public InputStream getDataStream() throws PGPException {
        if (this.getAlgorithm() == 0) {
            return this.getInputStream();
        }
        if (this.getAlgorithm() == 1) {
            return new InflaterInputStream(this.getInputStream(), new Inflater(true)){
                private boolean eof;
                {
                    this.eof = false;
                }

                protected void fill() throws IOException {
                    if (this.eof) {
                        throw new EOFException("Unexpected end of ZIP input stream");
                    }
                    this.len = this.in.read(this.buf, 0, this.buf.length);
                    if (this.len == -1) {
                        this.buf[0] = 0;
                        this.len = 1;
                        this.eof = true;
                    }
                    this.inf.setInput(this.buf, 0, this.len);
                }
            };
        }
        if (this.getAlgorithm() == 2) {
            return new InflaterInputStream(this.getInputStream()){
                private boolean eof;
                {
                    this.eof = false;
                }

                protected void fill() throws IOException {
                    if (this.eof) {
                        throw new EOFException("Unexpected end of ZIP input stream");
                    }
                    this.len = this.in.read(this.buf, 0, this.buf.length);
                    if (this.len == -1) {
                        this.buf[0] = 0;
                        this.len = 1;
                        this.eof = true;
                    }
                    this.inf.setInput(this.buf, 0, this.len);
                }
            };
        }
        if (this.getAlgorithm() == 3) {
            try {
                return new CBZip2InputStream(this.getInputStream());
            }
            catch (IOException e) {
                throw new PGPException("I/O problem with stream: " + e, e);
            }
        }
        throw new PGPException("can't recognise compression algorithm: " + this.getAlgorithm());
    }
}

