/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGOutputStream;
import cn.tca.TopBasicCrypto.openpgp.PGPLiteralData;
import cn.tca.TopBasicCrypto.openpgp.StreamGenerator;
import cn.tca.TopBasicCrypto.openpgp.WrappedGeneratorStream;
import cn.tca.TopBasicCrypto.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class PGPLiteralDataGenerator
implements StreamGenerator {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = PGPLiteralData.NOW;
    private BCPGOutputStream pkOut;
    private boolean oldFormat = false;

    public PGPLiteralDataGenerator() {
    }

    public PGPLiteralDataGenerator(boolean oldFormat) {
        this.oldFormat = oldFormat;
    }

    private void writeHeader(OutputStream out, char format, String name, long modificationTime) throws IOException {
        out.write(format);
        byte[] encName = Strings.toUTF8ByteArray(name);
        out.write((byte)encName.length);
        for (int i = 0; i != encName.length; ++i) {
            out.write(encName[i]);
        }
        long modDate = modificationTime / 1000L;
        out.write((byte)(modDate >> 24));
        out.write((byte)(modDate >> 16));
        out.write((byte)(modDate >> 8));
        out.write((byte)modDate);
    }

    public OutputStream open(OutputStream out, char format, String name, long length, Date modificationTime) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(out, 11, length + 2L + (long)name.length() + 4L, this.oldFormat);
        this.writeHeader(this.pkOut, format, name, modificationTime.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream out, char format, String name, Date modificationTime, byte[] buffer) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(out, 11, buffer);
        this.writeHeader(this.pkOut, format, name, modificationTime.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream out, char format, File file) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(out, 11, file.length() + 2L + (long)file.getName().length() + 4L, this.oldFormat);
        this.writeHeader(this.pkOut, format, file.getName(), file.lastModified());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public void close() throws IOException {
        if (this.pkOut != null) {
            this.pkOut.finish();
            this.pkOut.flush();
            this.pkOut = null;
        }
    }
}

