/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.bcpg.BCPGObject;
import cn.tca.TopBasicCrypto.bcpg.BCPGOutputStream;
import cn.tca.TopBasicCrypto.bcpg.ContainedPacket;
import cn.tca.TopBasicCrypto.bcpg.DSAPublicBCPGKey;
import cn.tca.TopBasicCrypto.bcpg.DSASecretBCPGKey;
import cn.tca.TopBasicCrypto.bcpg.ElGamalPublicBCPGKey;
import cn.tca.TopBasicCrypto.bcpg.ElGamalSecretBCPGKey;
import cn.tca.TopBasicCrypto.bcpg.PublicKeyPacket;
import cn.tca.TopBasicCrypto.bcpg.RSAPublicBCPGKey;
import cn.tca.TopBasicCrypto.bcpg.RSASecretBCPGKey;
import cn.tca.TopBasicCrypto.bcpg.S2K;
import cn.tca.TopBasicCrypto.bcpg.SecretKeyPacket;
import cn.tca.TopBasicCrypto.bcpg.SecretSubkeyPacket;
import cn.tca.TopBasicCrypto.bcpg.UserAttributePacket;
import cn.tca.TopBasicCrypto.bcpg.UserIDPacket;
import cn.tca.TopBasicCrypto.jce.interfaces.ElGamalPrivateKey;
import cn.tca.TopBasicCrypto.jce.spec.ElGamalParameterSpec;
import cn.tca.TopBasicCrypto.jce.spec.ElGamalPrivateKeySpec;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPKeyPair;
import cn.tca.TopBasicCrypto.openpgp.PGPPrivateKey;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKey;
import cn.tca.TopBasicCrypto.openpgp.PGPSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPSignatureGenerator;
import cn.tca.TopBasicCrypto.openpgp.PGPSignatureSubpacketVector;
import cn.tca.TopBasicCrypto.openpgp.PGPUserAttributeSubpacketVector;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class PGPSecretKey {
    final SecretKeyPacket secret;
    final PGPPublicKey pub;

    PGPSecretKey(SecretKeyPacket secret, PGPPublicKey pub) {
        this.secret = secret;
        this.pub = pub;
    }

    PGPSecretKey(PGPPrivateKey privKey, PGPPublicKey pubKey, int encAlgorithm, char[] passPhrase, boolean useSHA1, SecureRandom rand, Provider provider) throws PGPException {
        this(privKey, pubKey, encAlgorithm, passPhrase, useSHA1, rand, false, provider);
    }

    PGPSecretKey(PGPPrivateKey privKey, PGPPublicKey pubKey, int encAlgorithm, char[] passPhrase, boolean useSHA1, SecureRandom rand, boolean isMasterKey, Provider provider) throws PGPException {
        BCPGObject secKey;
        this.pub = pubKey;
        switch (pubKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rsK = (RSAPrivateCrtKey)privKey.getKey();
                secKey = new RSASecretBCPGKey(rsK.getPrivateExponent(), rsK.getPrimeP(), rsK.getPrimeQ());
                break;
            }
            case 17: {
                DSAPrivateKey dsK = (DSAPrivateKey)privKey.getKey();
                secKey = new DSASecretBCPGKey(dsK.getX());
                break;
            }
            case 16: 
            case 20: {
                ElGamalPrivateKey esK = (ElGamalPrivateKey)privKey.getKey();
                secKey = new ElGamalSecretBCPGKey(esK.getX());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        String cName = PGPUtil.getSymmetricCipherName(encAlgorithm);
        Cipher c = null;
        if (cName != null) {
            try {
                c = Cipher.getInstance(cName + "/CFB/NoPadding", provider);
            }
            catch (Exception e) {
                throw new PGPException("Exception creating cipher", e);
            }
        }
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pOut = new BCPGOutputStream(bOut);
            pOut.writeObject(secKey);
            byte[] keyData = bOut.toByteArray();
            pOut.write(PGPSecretKey.checksum(useSHA1, keyData, keyData.length));
            if (c != null) {
                byte[] iv = new byte[8];
                rand.nextBytes(iv);
                S2K s2k = new S2K(2, iv, 96);
                SecretKey key = PGPUtil.makeKeyFromPassPhrase(encAlgorithm, s2k, passPhrase, provider);
                c.init(1, (Key)key, rand);
                iv = c.getIV();
                byte[] encData = c.doFinal(bOut.toByteArray());
                int s2kUsage = useSHA1 ? 254 : 255;
                this.secret = isMasterKey ? new SecretKeyPacket(this.pub.publicPk, encAlgorithm, s2kUsage, s2k, iv, encData) : new SecretSubkeyPacket(this.pub.publicPk, encAlgorithm, s2kUsage, s2k, iv, encData);
            } else {
                this.secret = isMasterKey ? new SecretKeyPacket(this.pub.publicPk, encAlgorithm, null, null, bOut.toByteArray()) : new SecretSubkeyPacket(this.pub.publicPk, encAlgorithm, null, null, bOut.toByteArray());
            }
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception encrypting key", e);
        }
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, int encAlgorithm, char[] passPhrase, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, keyPair, id, encAlgorithm, passPhrase, false, hashedPcks, unhashedPcks, rand, provider);
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, keyPair, id, encAlgorithm, passPhrase, useSHA1, hashedPcks, unhashedPcks, rand, PGPUtil.getProvider(provider));
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, Provider provider) throws PGPException {
        this(keyPair.getPrivateKey(), PGPSecretKey.certifiedPublicKey(certificationLevel, keyPair, id, hashedPcks, unhashedPcks, provider), encAlgorithm, passPhrase, useSHA1, rand, true, provider);
    }

    private static PGPPublicKey certifiedPublicKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, Provider provider) throws PGPException {
        PGPSignatureGenerator sGen;
        try {
            sGen = new PGPSignatureGenerator(keyPair.getPublicKey().getAlgorithm(), 2, provider);
        }
        catch (Exception e) {
            throw new PGPException("creating signature generator: " + e, e);
        }
        sGen.initSign(certificationLevel, keyPair.getPrivateKey());
        sGen.setHashedSubpackets(hashedPcks);
        sGen.setUnhashedSubpackets(unhashedPcks);
        try {
            PGPSignature certification = sGen.generateCertification(id, keyPair.getPublicKey());
            return PGPPublicKey.addCertification(keyPair.getPublicKey(), id, certification);
        }
        catch (Exception e) {
            throw new PGPException("exception doing certification: " + e, e);
        }
    }

    public PGPSecretKey(int certificationLevel, int algorithm, PublicKey pubKey, PrivateKey privKey, Date time, String id, int encAlgorithm, char[] passPhrase, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, new PGPKeyPair(algorithm, pubKey, privKey, time), id, encAlgorithm, passPhrase, hashedPcks, unhashedPcks, rand, provider);
    }

    public PGPSecretKey(int certificationLevel, int algorithm, PublicKey pubKey, PrivateKey privKey, Date time, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, new PGPKeyPair(algorithm, pubKey, privKey, time), id, encAlgorithm, passPhrase, useSHA1, hashedPcks, unhashedPcks, rand, provider);
    }

    public boolean isSigningKey() {
        int algorithm = this.pub.getAlgorithm();
        return algorithm == 1 || algorithm == 3 || algorithm == 17 || algorithm == 19 || algorithm == 20;
    }

    public boolean isMasterKey() {
        return this.pub.isMasterKey();
    }

    public int getKeyEncryptionAlgorithm() {
        return this.secret.getEncAlgorithm();
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public Iterator getUserIDs() {
        return this.pub.getUserIDs();
    }

    public Iterator getUserAttributes() {
        return this.pub.getUserAttributes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] extractKeyData(char[] passPhrase, Provider provider) throws PGPException {
        String cName = PGPUtil.getSymmetricCipherName(this.secret.getEncAlgorithm());
        Cipher c = null;
        if (cName != null) {
            try {
                c = Cipher.getInstance(cName + "/CFB/NoPadding", provider);
            }
            catch (Exception e) {
                throw new PGPException("Exception creating cipher", e);
            }
        }
        byte[] encData = this.secret.getSecretKeyData();
        byte[] data = null;
        try {
            if (c == null) return encData;
            try {
                if (this.secret.getPublicKeyPacket().getVersion() == 4) {
                    IvParameterSpec ivSpec = new IvParameterSpec(this.secret.getIV());
                    SecretKey key = PGPUtil.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K(), passPhrase, provider);
                    c.init(2, (Key)key, ivSpec);
                    data = c.doFinal(encData, 0, encData.length);
                    boolean useSHA1 = this.secret.getS2KUsage() == 254;
                    byte[] check = PGPSecretKey.checksum(useSHA1, data, useSHA1 ? data.length - 20 : data.length - 2);
                    int i = 0;
                    while (i != check.length) {
                        if (check[i] != data[data.length - check.length + i]) {
                            throw new PGPException("checksum mismatch at " + i + " of " + check.length);
                        }
                        ++i;
                    }
                    return data;
                }
                SecretKey key = PGPUtil.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K(), passPhrase, provider);
                data = new byte[encData.length];
                byte[] iv = new byte[this.secret.getIV().length];
                System.arraycopy(this.secret.getIV(), 0, iv, 0, iv.length);
                int pos = 0;
                for (int i = 0; i != 4; ++i) {
                    c.init(2, (Key)key, new IvParameterSpec(iv));
                    int encLen = ((encData[pos] << 8 | encData[pos + 1] & 0xFF) + 7) / 8;
                    data[pos] = encData[pos];
                    data[pos + 1] = encData[pos + 1];
                    c.doFinal(encData, pos + 2, encLen, data, pos + 2);
                    pos += 2 + encLen;
                    if (i == 3) continue;
                    System.arraycopy(encData, pos - iv.length, iv, 0, iv.length);
                }
                int cs = encData[pos] << 8 & 0xFF00 | encData[pos + 1] & 0xFF;
                int calcCs = 0;
                for (int j = 0; j < data.length - 2; ++j) {
                    calcCs += data[j] & 0xFF;
                }
                if ((calcCs &= 0xFFFF) == cs) return data;
                throw new PGPException("checksum mismatch: passphrase wrong, expected " + Integer.toHexString(cs) + " found " + Integer.toHexString(calcCs));
            }
            catch (PGPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PGPException("Exception decrypting key", e);
            }
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }

    public PGPPrivateKey extractPrivateKey(char[] passPhrase, String provider) throws PGPException, NoSuchProviderException {
        return this.extractPrivateKey(passPhrase, PGPUtil.getProvider(provider));
    }

    public PGPPrivateKey extractPrivateKey(char[] passPhrase, Provider provider) throws PGPException {
        byte[] secKeyData = this.secret.getSecretKeyData();
        if (secKeyData == null || secKeyData.length < 1) {
            return null;
        }
        PublicKeyPacket pubPk = this.secret.getPublicKeyPacket();
        try {
            byte[] data = this.extractKeyData(passPhrase, provider);
            BCPGInputStream in = new BCPGInputStream(new ByteArrayInputStream(data));
            switch (pubPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaPub = (RSAPublicBCPGKey)pubPk.getKey();
                    RSASecretBCPGKey rsaPriv = new RSASecretBCPGKey(in);
                    RSAPrivateCrtKeySpec rsaPrivSpec = new RSAPrivateCrtKeySpec(rsaPriv.getModulus(), rsaPub.getPublicExponent(), rsaPriv.getPrivateExponent(), rsaPriv.getPrimeP(), rsaPriv.getPrimeQ(), rsaPriv.getPrimeExponentP(), rsaPriv.getPrimeExponentQ(), rsaPriv.getCrtCoefficient());
                    KeyFactory fact = KeyFactory.getInstance("RSA", provider);
                    return new PGPPrivateKey(fact.generatePrivate(rsaPrivSpec), this.getKeyID());
                }
                case 17: {
                    DSAPublicBCPGKey dsaPub = (DSAPublicBCPGKey)pubPk.getKey();
                    DSASecretBCPGKey dsaPriv = new DSASecretBCPGKey(in);
                    DSAPrivateKeySpec dsaPrivSpec = new DSAPrivateKeySpec(dsaPriv.getX(), dsaPub.getP(), dsaPub.getQ(), dsaPub.getG());
                    KeyFactory fact = KeyFactory.getInstance("DSA", provider);
                    return new PGPPrivateKey(fact.generatePrivate(dsaPrivSpec), this.getKeyID());
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elPub = (ElGamalPublicBCPGKey)pubPk.getKey();
                    ElGamalSecretBCPGKey elPriv = new ElGamalSecretBCPGKey(in);
                    ElGamalPrivateKeySpec elSpec = new ElGamalPrivateKeySpec(elPriv.getX(), new ElGamalParameterSpec(elPub.getP(), elPub.getG()));
                    KeyFactory fact = KeyFactory.getInstance("ElGamal", provider);
                    return new PGPPrivateKey(fact.generatePrivate(elSpec), this.getKeyID());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }

    private static byte[] checksum(boolean useSHA1, byte[] bytes, int length) throws PGPException {
        if (useSHA1) {
            try {
                MessageDigest dig = MessageDigest.getInstance("SHA1");
                dig.update(bytes, 0, length);
                return dig.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new PGPException("Can't find SHA-1", e);
            }
        }
        int checksum = 0;
        for (int i = 0; i != length; ++i) {
            checksum += bytes[i] & 0xFF;
        }
        byte[] check = new byte[]{(byte)(checksum >> 8), (byte)checksum};
        return check;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.secret);
        if (this.pub.trustPk != null) {
            out.writePacket(this.pub.trustPk);
        }
        if (this.pub.subSigs == null) {
            int i;
            for (i = 0; i != this.pub.keySigs.size(); ++i) {
                ((PGPSignature)this.pub.keySigs.get(i)).encode(out);
            }
            for (i = 0; i != this.pub.ids.size(); ++i) {
                if (this.pub.ids.get(i) instanceof String) {
                    String id = (String)this.pub.ids.get(i);
                    out.writePacket(new UserIDPacket(id));
                } else {
                    PGPUserAttributeSubpacketVector v = (PGPUserAttributeSubpacketVector)this.pub.ids.get(i);
                    out.writePacket(new UserAttributePacket(v.toSubpacketArray()));
                }
                if (this.pub.idTrusts.get(i) != null) {
                    out.writePacket((ContainedPacket)this.pub.idTrusts.get(i));
                }
                ArrayList sigs = (ArrayList)this.pub.idSigs.get(i);
                for (int j = 0; j != sigs.size(); ++j) {
                    ((PGPSignature)sigs.get(j)).encode(out);
                }
            }
        } else {
            for (int j = 0; j != this.pub.subSigs.size(); ++j) {
                ((PGPSignature)this.pub.subSigs.get(j)).encode(out);
            }
        }
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey key, char[] oldPassPhrase, char[] newPassPhrase, int newEncAlgorithm, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        return PGPSecretKey.copyWithNewPassword(key, oldPassPhrase, newPassPhrase, newEncAlgorithm, rand, PGPUtil.getProvider(provider));
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey key, char[] oldPassPhrase, char[] newPassPhrase, int newEncAlgorithm, SecureRandom rand, Provider provider) throws PGPException {
        byte[] keyData;
        byte[] rawKeyData = key.extractKeyData(oldPassPhrase, provider);
        int s2kUsage = key.secret.getS2KUsage();
        byte[] iv = null;
        S2K s2k = null;
        if (newEncAlgorithm == 0) {
            s2kUsage = 0;
            if (key.secret.getS2KUsage() == 254) {
                keyData = new byte[rawKeyData.length - 18];
                System.arraycopy(rawKeyData, 0, keyData, 0, keyData.length - 2);
                byte[] check = PGPSecretKey.checksum(false, keyData, keyData.length - 2);
                keyData[keyData.length - 2] = check[0];
                keyData[keyData.length - 1] = check[1];
            } else {
                keyData = rawKeyData;
            }
        } else {
            Cipher c = null;
            String cName = PGPUtil.getSymmetricCipherName(newEncAlgorithm);
            try {
                c = Cipher.getInstance(cName + "/CFB/NoPadding", provider);
            }
            catch (Exception e) {
                throw new PGPException("Exception creating cipher", e);
            }
            iv = new byte[8];
            rand.nextBytes(iv);
            s2k = new S2K(2, iv, 96);
            try {
                SecretKey sKey = PGPUtil.makeKeyFromPassPhrase(newEncAlgorithm, s2k, newPassPhrase, provider);
                c.init(1, (Key)sKey, rand);
                iv = c.getIV();
                keyData = c.doFinal(rawKeyData);
            }
            catch (PGPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PGPException("Exception encrypting key", e);
            }
        }
        SecretKeyPacket secret = null;
        secret = key.secret instanceof SecretSubkeyPacket ? new SecretSubkeyPacket(key.secret.getPublicKeyPacket(), newEncAlgorithm, s2kUsage, s2k, iv, keyData) : new SecretKeyPacket(key.secret.getPublicKeyPacket(), newEncAlgorithm, s2kUsage, s2k, iv, keyData);
        return new PGPSecretKey(secret, key.pub);
    }

    public static PGPSecretKey replacePublicKey(PGPSecretKey secretKey, PGPPublicKey publicKey) {
        if (publicKey.getKeyID() != secretKey.getKeyID()) {
            throw new IllegalArgumentException("keyIDs do not match");
        }
        return new PGPSecretKey(secretKey.secret, publicKey);
    }
}

