/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.bcpg.ContainedPacket;
import cn.tca.TopBasicCrypto.bcpg.PublicKeyPacket;
import cn.tca.TopBasicCrypto.bcpg.PublicSubkeyPacket;
import cn.tca.TopBasicCrypto.bcpg.SecretKeyPacket;
import cn.tca.TopBasicCrypto.bcpg.SecretSubkeyPacket;
import cn.tca.TopBasicCrypto.bcpg.TrustPacket;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPKeyRing;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKey;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKeyRing;
import cn.tca.TopBasicCrypto.openpgp.PGPSecretKey;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PGPSecretKeyRing
extends PGPKeyRing {
    List keys;
    List extraPubKeys;

    PGPSecretKeyRing(List keys) {
        this(keys, new ArrayList());
    }

    private PGPSecretKeyRing(List keys, List extraPubKeys) {
        this.keys = keys;
        this.extraPubKeys = extraPubKeys;
    }

    public PGPSecretKeyRing(byte[] encoding) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding));
    }

    public PGPSecretKeyRing(InputStream in) throws IOException, PGPException {
        this.keys = new ArrayList();
        this.extraPubKeys = new ArrayList();
        BCPGInputStream pIn = PGPSecretKeyRing.wrap(in);
        int initialTag = pIn.nextPacketTag();
        if (initialTag != 5 && initialTag != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(initialTag));
        }
        SecretKeyPacket secret = (SecretKeyPacket)pIn.readPacket();
        while (pIn.nextPacketTag() == 61) {
            pIn.readPacket();
        }
        TrustPacket trust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
        List keySigs = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
        ArrayList ids = new ArrayList();
        ArrayList idTrusts = new ArrayList();
        ArrayList idSigs = new ArrayList();
        PGPSecretKeyRing.readUserIDs(pIn, ids, idTrusts, idSigs);
        this.keys.add(new PGPSecretKey(secret, new PGPPublicKey(secret.getPublicKeyPacket(), trust, keySigs, ids, idTrusts, idSigs)));
        while (pIn.nextPacketTag() == 7 || pIn.nextPacketTag() == 14) {
            List sigList;
            TrustPacket subTrust;
            ContainedPacket sub;
            if (pIn.nextPacketTag() == 7) {
                sub = (SecretSubkeyPacket)pIn.readPacket();
                while (pIn.nextPacketTag() == 61) {
                    pIn.readPacket();
                }
                subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
                sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
                this.keys.add(new PGPSecretKey((SecretKeyPacket)sub, new PGPPublicKey(((SecretKeyPacket)sub).getPublicKeyPacket(), subTrust, sigList)));
                continue;
            }
            sub = (PublicSubkeyPacket)pIn.readPacket();
            subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
            sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
            this.extraPubKeys.add(new PGPPublicKey((PublicKeyPacket)sub, subTrust, sigList));
        }
    }

    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long keyId) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey k = (PGPSecretKey)this.keys.get(i);
            if (keyId != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    public Iterator getExtraPublicKeys() {
        return this.extraPubKeys.iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        Object k;
        int i;
        for (i = 0; i != this.keys.size(); ++i) {
            k = (PGPSecretKey)this.keys.get(i);
            ((PGPSecretKey)k).encode(outStream);
        }
        for (i = 0; i != this.extraPubKeys.size(); ++i) {
            k = (PGPPublicKey)this.extraPubKeys.get(i);
            ((PGPPublicKey)k).encode(outStream);
        }
    }

    public static PGPSecretKeyRing replacePublicKeys(PGPSecretKeyRing secretRing, PGPPublicKeyRing publicRing) {
        ArrayList<PGPSecretKey> newList = new ArrayList<PGPSecretKey>(secretRing.keys.size());
        for (PGPSecretKey sk : secretRing.keys) {
            PGPPublicKey pk = publicRing.getPublicKey(sk.getKeyID());
            newList.add(PGPSecretKey.replacePublicKey(sk, pk));
        }
        return new PGPSecretKeyRing(newList);
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing ring, char[] oldPassPhrase, char[] newPassPhrase, int newEncAlgorithm, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        return PGPSecretKeyRing.copyWithNewPassword(ring, oldPassPhrase, newPassPhrase, newEncAlgorithm, rand, PGPUtil.getProvider(provider));
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing ring, char[] oldPassPhrase, char[] newPassPhrase, int newEncAlgorithm, SecureRandom rand, Provider provider) throws PGPException {
        ArrayList<PGPSecretKey> newKeys = new ArrayList<PGPSecretKey>(ring.keys.size());
        Iterator keys = ring.getSecretKeys();
        while (keys.hasNext()) {
            newKeys.add(PGPSecretKey.copyWithNewPassword((PGPSecretKey)keys.next(), oldPassPhrase, newPassPhrase, newEncAlgorithm, rand, provider));
        }
        return new PGPSecretKeyRing(newKeys, ring.extraPubKeys);
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        ArrayList<PGPSecretKey> keys = new ArrayList<PGPSecretKey>(secRing.keys);
        boolean found = false;
        boolean masterFound = false;
        for (int i = 0; i != keys.size(); ++i) {
            PGPSecretKey key = (PGPSecretKey)keys.get(i);
            if (key.getKeyID() == secKey.getKeyID()) {
                found = true;
                keys.set(i, secKey);
            }
            if (!key.isMasterKey()) continue;
            masterFound = true;
        }
        if (!found) {
            if (secKey.isMasterKey()) {
                if (masterFound) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                keys.add(0, secKey);
            } else {
                keys.add(secKey);
            }
        }
        return new PGPSecretKeyRing(keys, secRing.extraPubKeys);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        ArrayList keys = new ArrayList(secRing.keys);
        boolean found = false;
        for (int i = 0; i < keys.size(); ++i) {
            PGPSecretKey key = (PGPSecretKey)keys.get(i);
            if (key.getKeyID() != secKey.getKeyID()) continue;
            found = true;
            keys.remove(i);
        }
        if (!found) {
            return null;
        }
        return new PGPSecretKeyRing(keys, secRing.extraPubKeys);
    }
}

