/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGOutputStream;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPObjectFactory;
import cn.tca.TopBasicCrypto.openpgp.PGPSecretKey;
import cn.tca.TopBasicCrypto.openpgp.PGPSecretKeyRing;
import cn.tca.TopBasicCrypto.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PGPSecretKeyRingCollection {
    private Map secretRings = new HashMap();
    private List order = new ArrayList();

    private PGPSecretKeyRingCollection(Map secretRings, List order) {
        this.secretRings = secretRings;
        this.order = order;
    }

    public PGPSecretKeyRingCollection(byte[] encoding) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding));
    }

    public PGPSecretKeyRingCollection(InputStream in) throws IOException, PGPException {
        Object obj;
        PGPObjectFactory pgpFact = new PGPObjectFactory(in);
        while ((obj = pgpFact.nextObject()) != null) {
            if (!(obj instanceof PGPSecretKeyRing)) {
                throw new PGPException(obj.getClass().getName() + " found where PGPSecretKeyRing expected");
            }
            PGPSecretKeyRing pgpSecret = (PGPSecretKeyRing)obj;
            Long key = new Long(pgpSecret.getPublicKey().getKeyID());
            this.secretRings.put(key, pgpSecret);
            this.order.add(key);
        }
    }

    public PGPSecretKeyRingCollection(Collection collection) throws IOException, PGPException {
        for (PGPSecretKeyRing pgpSecret : collection) {
            Long key = new Long(pgpSecret.getPublicKey().getKeyID());
            this.secretRings.put(key, pgpSecret);
            this.order.add(key);
        }
    }

    public int size() {
        return this.order.size();
    }

    public Iterator getKeyRings() {
        return this.secretRings.values().iterator();
    }

    public Iterator getKeyRings(String userID) throws PGPException {
        return this.getKeyRings(userID, false, false);
    }

    public Iterator getKeyRings(String userID, boolean matchPartial) throws PGPException {
        return this.getKeyRings(userID, matchPartial, false);
    }

    public Iterator getKeyRings(String userID, boolean matchPartial, boolean ignoreCase) throws PGPException {
        Iterator it = this.getKeyRings();
        ArrayList<PGPSecretKeyRing> rings = new ArrayList<PGPSecretKeyRing>();
        if (ignoreCase) {
            userID = Strings.toLowerCase(userID);
        }
        while (it.hasNext()) {
            PGPSecretKeyRing secRing = (PGPSecretKeyRing)it.next();
            Iterator uIt = secRing.getSecretKey().getUserIDs();
            while (uIt.hasNext()) {
                String next = (String)uIt.next();
                if (ignoreCase) {
                    next = Strings.toLowerCase(next);
                }
                if (matchPartial) {
                    if (next.indexOf(userID) <= -1) continue;
                    rings.add(secRing);
                    continue;
                }
                if (!next.equals(userID)) continue;
                rings.add(secRing);
            }
        }
        return rings.iterator();
    }

    public PGPSecretKey getSecretKey(long keyID) throws PGPException {
        Iterator it = this.getKeyRings();
        while (it.hasNext()) {
            PGPSecretKeyRing secRing = (PGPSecretKeyRing)it.next();
            PGPSecretKey sec = secRing.getSecretKey(keyID);
            if (sec == null) continue;
            return sec;
        }
        return null;
    }

    public PGPSecretKeyRing getSecretKeyRing(long keyID) throws PGPException {
        Long id = new Long(keyID);
        if (this.secretRings.containsKey(id)) {
            return (PGPSecretKeyRing)this.secretRings.get(id);
        }
        Iterator it = this.getKeyRings();
        while (it.hasNext()) {
            PGPSecretKeyRing secretRing = (PGPSecretKeyRing)it.next();
            PGPSecretKey secret = secretRing.getSecretKey(keyID);
            if (secret == null) continue;
            return secretRing;
        }
        return null;
    }

    public boolean contains(long keyID) throws PGPException {
        return this.getSecretKey(keyID) != null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        Iterator it = this.order.iterator();
        while (it.hasNext()) {
            PGPSecretKeyRing sr = (PGPSecretKeyRing)this.secretRings.get(it.next());
            sr.encode(out);
        }
    }

    public static PGPSecretKeyRingCollection addSecretKeyRing(PGPSecretKeyRingCollection ringCollection, PGPSecretKeyRing secretKeyRing) {
        Long key = new Long(secretKeyRing.getPublicKey().getKeyID());
        if (ringCollection.secretRings.containsKey(key)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPSecretKeyRing> newSecretRings = new HashMap<Long, PGPSecretKeyRing>(ringCollection.secretRings);
        ArrayList<Long> newOrder = new ArrayList<Long>(ringCollection.order);
        newSecretRings.put(key, secretKeyRing);
        newOrder.add(key);
        return new PGPSecretKeyRingCollection(newSecretRings, newOrder);
    }

    public static PGPSecretKeyRingCollection removeSecretKeyRing(PGPSecretKeyRingCollection ringCollection, PGPSecretKeyRing secretKeyRing) {
        Long key = new Long(secretKeyRing.getPublicKey().getKeyID());
        if (!ringCollection.secretRings.containsKey(key)) {
            throw new IllegalArgumentException("Collection does not contain a key with a keyID for the passed in ring.");
        }
        HashMap newSecretRings = new HashMap(ringCollection.secretRings);
        ArrayList newOrder = new ArrayList(ringCollection.order);
        newSecretRings.remove(key);
        for (int i = 0; i < newOrder.size(); ++i) {
            Long r = (Long)newOrder.get(i);
            if (r.longValue() != key.longValue()) continue;
            newOrder.remove(i);
            break;
        }
        return new PGPSecretKeyRingCollection(newSecretRings, newOrder);
    }
}

