/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.bcpg.BCPGOutputStream;
import cn.tca.TopBasicCrypto.bcpg.MPInteger;
import cn.tca.TopBasicCrypto.bcpg.SignaturePacket;
import cn.tca.TopBasicCrypto.bcpg.SignatureSubpacket;
import cn.tca.TopBasicCrypto.bcpg.TrustPacket;
import cn.tca.TopBasicCrypto.bcpg.UserAttributeSubpacket;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKey;
import cn.tca.TopBasicCrypto.openpgp.PGPSignatureSubpacketVector;
import cn.tca.TopBasicCrypto.openpgp.PGPUserAttributeSubpacketVector;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import cn.tca.TopBasicCrypto.util.BigIntegers;
import cn.tca.TopBasicCrypto.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;

public class PGPSignature {
    public static final int BINARY_DOCUMENT = 0;
    public static final int CANONICAL_TEXT_DOCUMENT = 1;
    public static final int STAND_ALONE = 2;
    public static final int DEFAULT_CERTIFICATION = 16;
    public static final int NO_CERTIFICATION = 17;
    public static final int CASUAL_CERTIFICATION = 18;
    public static final int POSITIVE_CERTIFICATION = 19;
    public static final int SUBKEY_BINDING = 24;
    public static final int PRIMARYKEY_BINDING = 25;
    public static final int DIRECT_KEY = 31;
    public static final int KEY_REVOCATION = 32;
    public static final int SUBKEY_REVOCATION = 40;
    public static final int CERTIFICATION_REVOCATION = 48;
    public static final int TIMESTAMP = 64;
    private SignaturePacket sigPck;
    private Signature sig;
    private int signatureType;
    private TrustPacket trustPck;
    private byte lastb;

    PGPSignature(BCPGInputStream pIn) throws IOException, PGPException {
        this((SignaturePacket)pIn.readPacket());
    }

    PGPSignature(SignaturePacket sigPacket) throws PGPException {
        this.sigPck = sigPacket;
        this.signatureType = this.sigPck.getSignatureType();
        this.trustPck = null;
    }

    PGPSignature(SignaturePacket sigPacket, TrustPacket trustPacket) throws PGPException {
        this(sigPacket);
        this.trustPck = trustPacket;
    }

    private void getSig(Provider provider) throws PGPException {
        try {
            this.sig = Signature.getInstance(PGPUtil.getSignatureName(this.sigPck.getKeyAlgorithm(), this.sigPck.getHashAlgorithm()), provider);
        }
        catch (Exception e) {
            throw new PGPException("can't set up signature object.", e);
        }
    }

    public int getVersion() {
        return this.sigPck.getVersion();
    }

    public int getKeyAlgorithm() {
        return this.sigPck.getKeyAlgorithm();
    }

    public int getHashAlgorithm() {
        return this.sigPck.getHashAlgorithm();
    }

    public void initVerify(PGPPublicKey pubKey, String provider) throws NoSuchProviderException, PGPException {
        this.initVerify(pubKey, PGPUtil.getProvider(provider));
    }

    public void initVerify(PGPPublicKey pubKey, Provider provider) throws PGPException {
        if (this.sig == null) {
            this.getSig(provider);
        }
        try {
            this.sig.initVerify(pubKey.getKey(provider));
        }
        catch (InvalidKeyException e) {
            throw new PGPException("invalid key.", e);
        }
        this.lastb = 0;
    }

    public void update(byte b) throws SignatureException {
        if (this.signatureType == 1) {
            if (b == 13) {
                this.sig.update((byte)13);
                this.sig.update((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.sig.update((byte)13);
                    this.sig.update((byte)10);
                }
            } else {
                this.sig.update(b);
            }
            this.lastb = b;
        } else {
            this.sig.update(b);
        }
    }

    public void update(byte[] bytes) throws SignatureException {
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] bytes, int off, int length) throws SignatureException {
        if (this.signatureType == 1) {
            int finish = off + length;
            for (int i = off; i != finish; ++i) {
                this.update(bytes[i]);
            }
        } else {
            this.sig.update(bytes, off, length);
        }
    }

    public boolean verify() throws PGPException, SignatureException {
        this.sig.update(this.getSignatureTrailer());
        return this.sig.verify(this.getSignature());
    }

    private void updateWithIdData(int header, byte[] idBytes) throws SignatureException {
        this.update((byte)header);
        this.update((byte)(idBytes.length >> 24));
        this.update((byte)(idBytes.length >> 16));
        this.update((byte)(idBytes.length >> 8));
        this.update((byte)idBytes.length);
        this.update(idBytes);
    }

    private void updateWithPublicKey(PGPPublicKey key) throws PGPException, SignatureException {
        byte[] keyBytes = this.getEncodedPublicKey(key);
        this.update((byte)-103);
        this.update((byte)(keyBytes.length >> 8));
        this.update((byte)keyBytes.length);
        this.update(keyBytes);
    }

    public boolean verifyCertification(PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey key) throws PGPException, SignatureException {
        this.updateWithPublicKey(key);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            UserAttributeSubpacket[] packets = userAttributes.toSubpacketArray();
            for (int i = 0; i != packets.length; ++i) {
                packets[i].encode(bOut);
            }
            this.updateWithIdData(209, bOut.toByteArray());
        }
        catch (IOException e) {
            throw new PGPException("cannot encode subpacket array", e);
        }
        this.update(this.sigPck.getSignatureTrailer());
        return this.sig.verify(this.getSignature());
    }

    public boolean verifyCertification(String id, PGPPublicKey key) throws PGPException, SignatureException {
        this.updateWithPublicKey(key);
        this.updateWithIdData(180, Strings.toByteArray(id));
        this.update(this.sigPck.getSignatureTrailer());
        return this.sig.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPPublicKey masterKey, PGPPublicKey pubKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(masterKey);
        this.updateWithPublicKey(pubKey);
        this.update(this.sigPck.getSignatureTrailer());
        return this.sig.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPPublicKey pubKey) throws SignatureException, PGPException {
        if (this.getSignatureType() != 32 && this.getSignatureType() != 40) {
            throw new IllegalStateException("signature is not a key signature");
        }
        this.updateWithPublicKey(pubKey);
        this.update(this.sigPck.getSignatureTrailer());
        return this.sig.verify(this.getSignature());
    }

    public int getSignatureType() {
        return this.sigPck.getSignatureType();
    }

    public long getKeyID() {
        return this.sigPck.getKeyID();
    }

    public Date getCreationTime() {
        return new Date(this.sigPck.getCreationTime());
    }

    public byte[] getSignatureTrailer() {
        return this.sigPck.getSignatureTrailer();
    }

    public boolean hasSubpackets() {
        return this.sigPck.getHashedSubPackets() != null || this.sigPck.getUnhashedSubPackets() != null;
    }

    public PGPSignatureSubpacketVector getHashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getHashedSubPackets());
    }

    public PGPSignatureSubpacketVector getUnhashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getUnhashedSubPackets());
    }

    private PGPSignatureSubpacketVector createSubpacketVector(SignatureSubpacket[] pcks) {
        if (pcks != null) {
            return new PGPSignatureSubpacketVector(pcks);
        }
        return null;
    }

    public byte[] getSignature() throws PGPException {
        byte[] signature;
        MPInteger[] sigValues = this.sigPck.getSignature();
        if (sigValues != null) {
            if (sigValues.length == 1) {
                signature = BigIntegers.asUnsignedByteArray(sigValues[0].getValue());
            } else {
                try {
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    v.add(new DERInteger(sigValues[0].getValue()));
                    v.add(new DERInteger(sigValues[1].getValue()));
                    signature = new DERSequence(v).getEncoded();
                }
                catch (IOException e) {
                    throw new PGPException("exception encoding DSA sig.", e);
                }
            }
        } else {
            signature = this.sigPck.getSignatureBytes();
        }
        return signature;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.sigPck);
        if (this.trustPck != null) {
            out.writePacket(this.trustPck);
        }
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pubKey) throws PGPException {
        byte[] keyBytes;
        try {
            keyBytes = pubKey.publicPk.getEncodedContents();
        }
        catch (IOException e) {
            throw new PGPException("exception preparing key.", e);
        }
        return keyBytes;
    }
}

