/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.operator.bc;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.crypto.AsymmetricBlockCipher;
import cn.tca.TopBasicCrypto.crypto.CipherParameters;
import cn.tca.TopBasicCrypto.crypto.InvalidCipherTextException;
import cn.tca.TopBasicCrypto.crypto.params.AsymmetricKeyParameter;
import cn.tca.TopBasicCrypto.crypto.params.ParametersWithRandom;
import cn.tca.TopBasicCrypto.operator.AsymmetricKeyWrapper;
import cn.tca.TopBasicCrypto.operator.GenericKey;
import cn.tca.TopBasicCrypto.operator.OperatorException;
import cn.tca.TopBasicCrypto.operator.bc.OperatorUtils;
import java.security.SecureRandom;

public abstract class BcAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private AsymmetricKeyParameter publicKey;
    private SecureRandom random;

    public BcAsymmetricKeyWrapper(AlgorithmIdentifier encAlgId, AsymmetricKeyParameter publicKey) {
        super(encAlgId);
        this.publicKey = publicKey;
    }

    public BcAsymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        AsymmetricBlockCipher keyEncryptionCipher = this.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        CipherParameters params = this.publicKey;
        if (this.random != null) {
            params = new ParametersWithRandom(params, this.random);
        }
        try {
            byte[] keyEnc = OperatorUtils.getKeyBytes(encryptionKey);
            keyEncryptionCipher.init(true, this.publicKey);
            return keyEncryptionCipher.processBlock(keyEnc, 0, keyEnc.length);
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to encrypt contents key", e);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier var1);
}

