/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.operator.bc;

import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.crypto.Digest;
import cn.tca.TopBasicCrypto.operator.DigestCalculator;
import cn.tca.TopBasicCrypto.operator.DigestCalculatorProvider;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.operator.bc.BcUtil;
import java.io.IOException;
import java.io.OutputStream;

public class BcDigestCalculatorProvider
implements DigestCalculatorProvider {
    private DigestOutputStream stream;

    public DigestCalculator get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
        Digest dig = BcUtil.createDigest(algorithm);
        this.stream = new DigestOutputStream(dig);
        return new DigestCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithm;
            }

            public OutputStream getOutputStream() {
                return BcDigestCalculatorProvider.this.stream;
            }

            public byte[] getDigest() {
                return BcDigestCalculatorProvider.this.stream.getDigest();
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest dig) {
            this.dig = dig;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes, 0, bytes.length);
        }

        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            byte[] d = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(d, 0);
            return d;
        }
    }
}

