/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.tsp;

import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.DERBitString;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.DERUTF8String;
import cn.tca.TopBasicCrypto.asn1.cmp.PKIFreeText;
import cn.tca.TopBasicCrypto.asn1.cmp.PKIStatusInfo;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.tsp.TimeStampResp;
import cn.tca.TopBasicCrypto.tsp.TSPException;
import cn.tca.TopBasicCrypto.tsp.TSPValidationException;
import cn.tca.TopBasicCrypto.tsp.TimeStampRequest;
import cn.tca.TopBasicCrypto.tsp.TimeStampResponse;
import cn.tca.TopBasicCrypto.tsp.TimeStampTokenGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.Set;

public class TimeStampResponseGenerator {
    int status;
    ASN1EncodableVector statusStrings;
    int failInfo;
    private TimeStampTokenGenerator tokenGenerator;
    private Set acceptedAlgorithms;
    private Set acceptedPolicies;
    private Set acceptedExtensions;

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms) {
        this(tokenGenerator, acceptedAlgorithms, null, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicy) {
        this(tokenGenerator, acceptedAlgorithms, acceptedPolicy, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicies, Set acceptedExtensions) {
        this.tokenGenerator = tokenGenerator;
        this.acceptedAlgorithms = acceptedAlgorithms;
        this.acceptedPolicies = acceptedPolicies;
        this.acceptedExtensions = acceptedExtensions;
        this.statusStrings = new ASN1EncodableVector();
    }

    private void addStatusString(String statusString) {
        this.statusStrings.add(new DERUTF8String(statusString));
    }

    private void setFailInfoField(int field) {
        this.failInfo |= field;
    }

    private PKIStatusInfo getPKIStatusInfo() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(this.status));
        if (this.statusStrings.size() > 0) {
            v.add(new PKIFreeText(new DERSequence(this.statusStrings)));
        }
        if (this.failInfo != 0) {
            FailInfo failInfoBitString = new FailInfo(this.failInfo);
            v.add(failInfoBitString);
        }
        return new PKIStatusInfo(new DERSequence(v));
    }

    public TimeStampResponse generate(TimeStampRequest request, BigInteger serialNumber, Date genTime, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, TSPException {
        TimeStampResp resp;
        try {
            if (genTime == null) {
                throw new TSPValidationException("The time source is not available.", 512);
            }
            request.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions, provider);
            this.status = 0;
            this.addStatusString("Operation Okay");
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            ContentInfo tstTokenContentInfo = null;
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(this.tokenGenerator.generate(request, serialNumber, genTime, provider).toCMSSignedData().getEncoded());
                ASN1InputStream aIn = new ASN1InputStream(bIn);
                tstTokenContentInfo = ContentInfo.getInstance(aIn.readObject());
            }
            catch (IOException ioEx) {
                throw new TSPException("Timestamp token received cannot be converted to ContentInfo", ioEx);
            }
            resp = new TimeStampResp(pkiStatusInfo, tstTokenContentInfo);
        }
        catch (TSPValidationException e) {
            this.status = 2;
            this.setFailInfoField(e.getFailureCode());
            this.addStatusString(e.getMessage());
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            resp = new TimeStampResp(pkiStatusInfo, null);
        }
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException e) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generate(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        TimeStampResp resp;
        try {
            if (genTime == null) {
                throw new TSPValidationException("The time source is not available.", 512);
            }
            request.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions);
            this.status = 0;
            this.addStatusString("Operation Okay");
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            ContentInfo tstTokenContentInfo = null;
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(this.tokenGenerator.generate(request, serialNumber, genTime).toCMSSignedData().getEncoded());
                ASN1InputStream aIn = new ASN1InputStream(bIn);
                tstTokenContentInfo = ContentInfo.getInstance(aIn.readObject());
            }
            catch (IOException ioEx) {
                throw new TSPException("Timestamp token received cannot be converted to ContentInfo", ioEx);
            }
            resp = new TimeStampResp(pkiStatusInfo, tstTokenContentInfo);
        }
        catch (TSPValidationException e) {
            this.status = 2;
            this.setFailInfoField(e.getFailureCode());
            this.addStatusString(e.getMessage());
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            resp = new TimeStampResp(pkiStatusInfo, null);
        }
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException e) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generateFailResponse(int status, int failInfoField, String statusString) throws TSPException {
        this.status = status;
        this.setFailInfoField(failInfoField);
        if (statusString != null) {
            this.addStatusString(statusString);
        }
        PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
        TimeStampResp resp = new TimeStampResp(pkiStatusInfo, null);
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException e) {
            throw new TSPException("created badly formatted response!");
        }
    }

    class FailInfo
    extends DERBitString {
        FailInfo(int failInfoValue) {
            super(FailInfo.getBytes(failInfoValue), FailInfo.getPadBits(failInfoValue));
        }
    }
}

