/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.impl.httpclient4;

import java.net.URL;
import javax.net.ssl.SSLContext;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.AxisRequestEntity;
import org.apache.axis2.transport.http.HTTPSender;
import org.apache.axis2.transport.http.Request;
import org.apache.axis2.transport.http.impl.httpclient4.RequestImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;

public class HTTPSenderImpl
extends HTTPSender {
    private static final Log log = LogFactory.getLog(HTTPSenderImpl.class);

    @Override
    protected Request createRequest(MessageContext msgContext, String methodName, URL url, AxisRequestEntity requestEntity) throws AxisFault {
        return new RequestImpl(this.getHttpClient(msgContext), msgContext, methodName, url, requestEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient getHttpClient(MessageContext msgContext) {
        ConfigurationContext configContext = msgContext.getConfigurationContext();
        HttpClient httpClient = (HttpClient)msgContext.getProperty("CACHED_HTTP_CLIENT");
        if (httpClient == null) {
            httpClient = (HttpClient)configContext.getProperty("CACHED_HTTP_CLIENT");
        }
        if (httpClient != null) {
            return httpClient;
        }
        HTTPSenderImpl hTTPSenderImpl = this;
        synchronized (hTTPSenderImpl) {
            httpClient = (HttpClient)msgContext.getProperty("CACHED_HTTP_CLIENT");
            if (httpClient == null) {
                httpClient = (HttpClient)configContext.getProperty("CACHED_HTTP_CLIENT");
            }
            if (httpClient != null) {
                return httpClient;
            }
            HttpClientConnectionManager connManager = (HttpClientConnectionManager)msgContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
            if (connManager == null) {
                connManager = (HttpClientConnectionManager)msgContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
            }
            if (connManager == null) {
                ConfigurationContext configurationContext = configContext;
                synchronized (configurationContext) {
                    connManager = (HttpClientConnectionManager)configContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
                    if (connManager == null) {
                        log.trace((Object)"Making new ConnectionManager");
                        SSLContext sslContext = (SSLContext)configContext.getProperty(SSLContext.class.getName());
                        if (sslContext == null) {
                            sslContext = SSLContexts.createDefault();
                        }
                        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
                        connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                        ((PoolingHttpClientConnectionManager)connManager).setMaxTotal(200);
                        ((PoolingHttpClientConnectionManager)connManager).setDefaultMaxPerRoute(200);
                        configContext.setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)connManager);
                    }
                }
            }
            return HttpClientBuilder.create().setConnectionManager(connManager).setConnectionManagerShared(true).build();
        }
    }
}

