/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.TCAErrCode;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;

abstract class BaseVerifier {
    BaseVerifier() {
    }

    public X509Certificate verifyCert(X509Certificate cert, X509Certificate CACert, Date date) throws CertApiException {
        if (!cert.getIssuerX500Principal().equals(CACert.getSubjectX500Principal())) {
            throw new CertApiException(TCAErrCode.ERR_CERT_UNKNOWNCA);
        }
        try {
            cert.checkValidity(date);
        }
        catch (CertificateNotYetValidException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_NOTYETVALID, (Throwable)e);
        }
        catch (CertificateExpiredException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_EXCEPTION, (Throwable)e);
        }
        try {
            cert.verify(CACert.getPublicKey());
        }
        catch (Exception e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_BADSIGN, (Throwable)e);
        }
        return cert;
    }
}

