/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.topca.api.cert.BaseVerifier;
import cn.topca.api.cert.CRLDownloader;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.DownloaderState;
import cn.topca.api.cert.IVerifierProvider;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.VerifierConfig;
import java.io.File;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CRLVerifyProvider
extends BaseVerifier
implements IVerifierProvider {
    private String baseCrlUrl;
    private String deltaCrlUrl;
    private String baseFilePath;
    private String deltaFilePath;
    private boolean checkRevoke = false;
    private boolean hasDelta = false;
    private X509Certificate caCert;
    private CRLDownloader baseDownloader;
    private CRLDownloader deltaDownloader;

    @Override
    public boolean config(Map<String, String> config) {
        return false;
    }

    @Override
    public boolean config(VerifierConfig config) {
        this.caCert = config.getCaCert();
        this.baseCrlUrl = config.getBaseCrlUrl();
        this.checkRevoke = config.isCheckRevoke();
        if (!this.checkRevoke) {
            return true;
        }
        String savePath = config.getSavePath();
        this.baseFilePath = savePath + File.separator + this.caCert.getSerialNumber().toString(16).toUpperCase() + "_BASE.crl";
        this.baseDownloader = new CRLDownloader(this.caCert, this.baseFilePath, this.baseCrlUrl, config.getRetryPolicy());
        this.baseDownloader.start();
        if (config.getType() == 2) {
            this.hasDelta = true;
            this.deltaCrlUrl = config.getDeltaCrlUrl();
            this.deltaFilePath = savePath + File.separator + this.caCert.getSerialNumber().toString(16).toUpperCase() + "_DELTA.crl";
            this.deltaDownloader = new CRLDownloader(this.caCert, this.deltaFilePath, this.deltaCrlUrl, config.getRetryPolicy());
            this.deltaDownloader.start();
        }
        return true;
    }

    private void checkDownloaderState(CRLDownloader downloader) throws CertApiException {
        if (downloader.getDownloaderState() == DownloaderState.DOWNLOADER_STATE_RUNNING) {
            throw new CertApiException(TCAErrCode.ERR_CRL_THREADRUNNING);
        }
        if (downloader.getDownloaderState() == DownloaderState.DOWNLOADER_STATE_WAITING) {
            throw new CertApiException(TCAErrCode.ERR_CRL_THREADWAITING);
        }
        if (downloader.getDownloaderState() == DownloaderState.DOWNLOADER_STATE_ERROR) {
            throw new CertApiException(TCAErrCode.ERR_CRL_THREADERROR);
        }
        if (downloader.getDownloaderState() == DownloaderState.DOWNLOADER_STATE_STOP) {
            throw new CertApiException(TCAErrCode.ERR_CRL_THREADSTOP);
        }
    }

    @Override
    public boolean verify(X509Certificate cert, Date date) throws CertApiException {
        super.verifyCert(cert, this.caCert, date);
        if (!this.checkRevoke) {
            return true;
        }
        boolean certIsValid = false;
        X509CRL crl = this.baseDownloader.getCRL();
        if (crl == null) {
            this.checkDownloaderState(this.baseDownloader);
        } else {
            boolean bl = certIsValid = !crl.isRevoked(cert);
        }
        if (certIsValid && this.hasDelta) {
            crl = this.deltaDownloader.getCRL();
            if (crl == null) {
                this.checkDownloaderState(this.deltaDownloader);
            } else {
                certIsValid = !crl.isRevoked(cert);
            }
        }
        return certIsValid;
    }

    @Override
    public boolean test() {
        return false;
    }

    public String getBaseCrlUrl() {
        return this.baseCrlUrl;
    }

    public String getDeltaCrlUrl() {
        return this.deltaCrlUrl;
    }

    public String getBaseFilePath() {
        return this.baseFilePath;
    }

    public String getDeltaFilePath() {
        return this.deltaFilePath;
    }

    public boolean isCheckRevoke() {
        return this.checkRevoke;
    }

    public boolean isHasDelta() {
        return this.hasDelta;
    }
}

