/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.x509.CRLDistPoint;
import cn.tca.TopBasicCrypto.asn1.x509.DistributionPoint;
import cn.tca.TopBasicCrypto.asn1.x509.DistributionPointName;
import cn.tca.TopBasicCrypto.asn1.x509.GeneralName;
import cn.tca.TopBasicCrypto.asn1.x509.GeneralNames;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.ConfigMgr;
import cn.topca.api.cert.KeyStoreMgr;
import cn.topca.api.cert.LicenseMgr;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import cn.topca.api.cert.VerifierMgr;
import cn.topca.core.ext.bc.cms.CMSAlgorithm;
import cn.topca.core.ext.bc.cms.CMSEnvelopedData;
import cn.topca.core.ext.bc.cms.CMSOperatorUtils;
import cn.topca.core.ext.bc.cms.CMSSignedData;
import cn.topca.core.ext.bc.cms.SignerInfoGenerator;
import cn.topca.crypto.Cipher;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHKey;
import org.apache.commons.codec.binary.Hex;

public class Certificate {
    private X509Certificate cert;
    private Provider _provider = null;
    private static final Map<String, String> _extendedKeyUsageMap = new HashMap<String, String>();
    private static KeyStoreMgr keyMgr = KeyStoreMgr.getInstance();
    private static VerifierMgr verMgr = VerifierMgr.getInstance();
    private static LicenseMgr licMgr = LicenseMgr.getInstance();

    public Certificate(String b64Str) throws CertApiException {
        b64Str = b64Str.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", "").replaceAll("\r", "").replaceAll("\n", "");
        this.init(TCAUtil.decode(b64Str));
    }

    public Certificate(byte[] certData) throws CertApiException {
        this.init(certData);
    }

    private void init(byte[] binCertData) throws CertApiException {
        this.cert = TCAUtil.convBin2Cert(binCertData);
        this._provider = this.cert.getPublicKey().getAlgorithm().contains("RSA") ? TCAUtil.getBcProvider() : TCAUtil.getSm2Provider();
        if (!licMgr.certWithLicense(this.cert)) {
            throw new CertApiException(TCAErrCode.ERR_CERT_UNLIC);
        }
    }

    public String serialNumber() {
        return Hex.encodeHexString((byte[])this.cert.getSerialNumber().toByteArray()).toUpperCase();
    }

    public String subject() {
        return this.cert.getSubjectX500Principal().toString();
    }

    public String issuer() {
        return this.cert.getIssuerX500Principal().toString();
    }

    public Date notBefore() {
        return this.cert.getNotBefore();
    }

    public Date notAfter() {
        return this.cert.getNotAfter();
    }

    public String[] keyUsage() {
        int iKeyUsage = this.doKeyUsage();
        if (iKeyUsage == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (0 != (iKeyUsage & 0x80)) {
            ret.add("digitalSignature");
        }
        if (0 != (iKeyUsage & 0x40)) {
            ret.add("nonRepudiation");
        }
        if (0 != (iKeyUsage & 0x20)) {
            ret.add("keyEncipherment");
        }
        if (0 != (iKeyUsage & 0x10)) {
            ret.add("dataEncipherment");
        }
        if (0 != (iKeyUsage & 8)) {
            ret.add("keyAgreement");
        }
        if (0 != (iKeyUsage & 4)) {
            ret.add("keyCertSign");
        }
        if (0 != (iKeyUsage & 2)) {
            ret.add("cRLSign");
        }
        if (0 != (iKeyUsage & 1)) {
            ret.add("encipherOnly");
        }
        if (0 != (iKeyUsage & 0x8000)) {
            ret.add("decipherOnly");
        }
        if (0 != (iKeyUsage & 0x40)) {
            ret.add("contentCommitment");
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String[] extededKeyUsage() throws CertApiException {
        try {
            List<String> list = this.cert.getExtendedKeyUsage();
            if (list == null || list.size() == 0) {
                return new String[0];
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : list) {
                if (_extendedKeyUsageMap.get(s) == null) continue;
                ret.add(_extendedKeyUsageMap.get(s));
            }
            return ret.toArray(new String[ret.size()]);
        }
        catch (CertificateParsingException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_PARSINGERR, (Throwable)e);
        }
    }

    public String crlUrl() throws CertApiException {
        String[] ret = this.crlUrls();
        return ret.length == 0 ? null : ret[0];
    }

    public boolean verify() throws CertApiException {
        return this.verify(new Date());
    }

    public boolean verify(Date date) throws CertApiException {
        return verMgr.verify(this.cert, date);
    }

    public String signAlg() {
        return this.cert.getSigAlgName();
    }

    public String publicKeyAlg() {
        return this.cert.getPublicKey().getAlgorithm();
    }

    public int publicKeySize() {
        PublicKey pubKey = this.cert.getPublicKey();
        if (pubKey instanceof RSAKey) {
            return ((RSAKey)((Object)pubKey)).getModulus().bitLength();
        }
        if (pubKey instanceof DSAKey) {
            return ((DSAKey)((Object)pubKey)).getParams().getP().bitLength();
        }
        if (pubKey instanceof DHKey) {
            return ((DHKey)((Object)pubKey)).getParams().getP().bitLength();
        }
        if ("SM2".equals(pubKey.getAlgorithm())) {
            return 256;
        }
        return -1;
    }

    public String signLogondata(String plain) throws CertApiException {
        plain = "LOGONDATA:" + plain;
        try {
            byte[] plainData = plain.getBytes("UTF-8");
            byte[] result = this.signP7(plainData);
            return TCAUtil.encode(result);
        }
        catch (UnsupportedEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_STR_ENCODING, (Throwable)e);
        }
    }

    public byte[] signP7(byte[] plainData) throws CertApiException {
        return this.signP7(plainData, true);
    }

    public byte[] signP7(byte[] plainData, boolean includeContent) throws CertApiException {
        String hashAlg = this.publicKeyAlg().equalsIgnoreCase("RSA") ? "SHA1" : "SM3";
        return this.signP7(plainData, includeContent, hashAlg);
    }

    public byte[] signP7(byte[] plainData, boolean includeContent, String hashAlg) throws CertApiException {
        this.checkHashAlg(hashAlg);
        boolean includeAuthAttr = this.publicKeyAlg().equalsIgnoreCase("SM2");
        if (!ConfigMgr.getInstance().getBoolConfig("signQ7")) {
            includeAuthAttr = false;
        }
        PrivateKey priKey = KeyStoreMgr.getInstance().getPriKeyByCert(this.cert);
        return this.doSign(plainData, hashAlg, priKey, this._provider, true, includeContent, includeAuthAttr);
    }

    public byte[] signRaw(byte[] plainData) throws CertApiException {
        String hashAlg = this.publicKeyAlg().equalsIgnoreCase("RSA") ? "SHA1" : "SM3";
        return this.signRaw(plainData, hashAlg);
    }

    public byte[] signRaw(byte[] plainData, String hashAlg) throws CertApiException {
        this.checkHashAlg(hashAlg);
        PrivateKey priKey = keyMgr.getPriKeyByCert(this.cert);
        String alg = hashAlg + "With" + this.publicKeyAlg();
        try {
            Signature sig = Signature.getInstance(alg, this._provider);
            sig.initSign(priKey);
            sig.update(plainData);
            return sig.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
        }
        catch (SignatureException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_SIGNATRUE, (Throwable)e);
        }
    }

    public boolean verifyRaw(byte[] binRawSign, byte[] plainData) throws CertApiException {
        String hashAlg = this.publicKeyAlg().equalsIgnoreCase("RSA") ? "SHA1" : "SM3";
        return this.verifyRaw(binRawSign, plainData, hashAlg);
    }

    public boolean verifyRaw(byte[] binRawSign, byte[] plainData, String hashAlg) throws CertApiException {
        this.checkHashAlg(hashAlg);
        PublicKey pubKey = this.cert.getPublicKey();
        String alg = hashAlg + "With" + this.publicKeyAlg();
        try {
            Signature sig = Signature.getInstance(alg, this._provider);
            sig.initVerify(pubKey);
            sig.update(plainData);
            return sig.verify(binRawSign);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
        }
        catch (SignatureException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_SIGNATRUE, (Throwable)e);
        }
    }

    public byte[] encryptP7(byte[] plainData) throws CertApiException {
        String symmAlg = this.publicKeyAlg().equalsIgnoreCase("SM2") ? "SM4" : "3DES";
        return this.encryptP7(plainData, symmAlg);
    }

    public byte[] encryptP7(byte[] plainData, String symmAlg) throws CertApiException {
        if (symmAlg.equalsIgnoreCase("SM1")) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET);
        }
        ASN1ObjectIdentifier alg = this.convSymmAlg(symmAlg);
        try {
            CMSEnvelopedData cmsEnvelopedData = CMSOperatorUtils.generateEnvelopedData((byte[])plainData, (java.security.cert.Certificate)this.cert, (ASN1ObjectIdentifier)alg, (boolean)false);
            return cmsEnvelopedData.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_ENCODING, (Throwable)e);
        }
        catch (CMSException e) {
            throw new CertApiException(TCAErrCode.ERR_GENERATE_ENVELOPDATA, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_ENCODE, (Throwable)e);
        }
    }

    public byte[] encryptRaw(byte[] plainData) throws CertApiException {
        if (this.publicKeyAlg().equalsIgnoreCase("RSA") && plainData.length > this.publicKeySize() / 8 - 11) {
            throw new CertApiException(TCAErrCode.ERR_PLAIN_RUNAWAY);
        }
        String algorithm = this.cert.getPublicKey().getAlgorithm();
        try {
            Cipher cipher = Cipher.getInstance((String)algorithm, (Provider)this._provider);
            cipher.init(1, (Key)this.cert.getPublicKey());
            return cipher.doFinal(plainData);
        }
        catch (IllegalBlockSizeException e) {
            throw new CertApiException(TCAErrCode.ERR_ILLEGAL_BLOCK, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PADDING, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_PADDING, (Throwable)e);
        }
    }

    public byte[] decryptRaw(byte[] binEncData) throws CertApiException {
        PrivateKey priKey = keyMgr.getPriKeyByCert(this.cert);
        String algorithm = this.cert.getPublicKey().getAlgorithm();
        try {
            Cipher cipher = Cipher.getInstance((String)algorithm, (Provider)this._provider);
            cipher.init(2, (Key)priKey);
            return cipher.doFinal(binEncData);
        }
        catch (IllegalBlockSizeException e) {
            throw new CertApiException(TCAErrCode.ERR_ILLEGAL_BLOCK, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PADDING, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_PADDING, (Throwable)e);
        }
    }

    public String toBase64() throws CertApiException {
        try {
            return TCAUtil.encode(this.cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_ENCODECERT, (Throwable)e);
        }
    }

    private byte[] doSign(byte[] plain, String hashAlg, PrivateKey priKey, Provider provider, boolean includeCert, boolean includeContent, boolean includeAuthAttr) throws CertApiException {
        try {
            ArrayList<X509CertificateHolder> certs;
            SignerInfoGenerator sig = TCAUtil.genSignerInfoGenerator(this.cert, priKey, hashAlg, includeAuthAttr, provider);
            ArrayList<SignerInfoGenerator> sigs = new ArrayList<SignerInfoGenerator>();
            sigs.add(sig);
            if (includeCert) {
                certs = new ArrayList<X509CertificateHolder>();
                X509CertificateHolder c = new X509CertificateHolder(this.cert.getEncoded());
                certs.add(c);
            } else {
                certs = null;
            }
            CMSSignedData cms = TCAUtil.doGenSignedData(plain, sigs, certs, null, includeContent);
            return cms.getContentInfo().getEncoded("DER");
        }
        catch (OperatorCreationException e) {
            throw new CertApiException(TCAErrCode.ERR_OPERATORCREATION, (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_ENCODING, (Throwable)e);
        }
        catch (CMSException e) {
            throw new CertApiException(TCAErrCode.ERR_GENERATE_ENVELOPDATA, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    private int doKeyUsage() {
        boolean[] bKeyUsageArr = this.cert.getKeyUsage();
        if (bKeyUsageArr == null) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < bKeyUsageArr.length; ++i) {
            if (!bKeyUsageArr[i]) continue;
            ret |= 1 << i;
        }
        return ret;
    }

    private String[] crlUrls() throws CertApiException {
        byte[] extData = this.cert.getExtensionValue("2.5.29.31");
        if (extData == null) {
            return new String[0];
        }
        try {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)((DEROctetString)new ASN1InputStream(extData).readObject()).getOctets());
            CRLDistPoint crlDP = CRLDistPoint.getInstance((Object)seq);
            if (crlDP == null) {
                return null;
            }
            DistributionPoint[] dps = crlDP.getDistributionPoints();
            if (dps.length == 0) {
                return new String[0];
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (DistributionPoint dp : dps) {
                DistributionPointName dpn = dp.getDistributionPoint();
                if (dpn.getType() != 0) continue;
                GeneralName[] gns = GeneralNames.getInstance((Object)dpn.getName()).getNames();
                if (gns.length == 0) {
                    return new String[0];
                }
                for (GeneralName gn : gns) {
                    if (gn.getTagNo() != 6) continue;
                    ret.add(gn.getName().toString());
                }
            }
            return ret.toArray(new String[ret.size()]);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    private boolean checkHashAlg(String hashAlg) throws CertApiException {
        if (hashAlg.equalsIgnoreCase("SM3") && this.publicKeyAlg().equals("RSA")) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET);
        }
        if ((hashAlg.equalsIgnoreCase("SHA256") || hashAlg.equalsIgnoreCase("SHA1")) && this.publicKeyAlg().equals("SM2")) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET);
        }
        if (hashAlg.equals("SHA256")) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET);
        }
        return true;
    }

    private ASN1ObjectIdentifier convSymmAlg(String symmAlg) throws CertApiException {
        if (symmAlg.equalsIgnoreCase("AES")) {
            return CMSAlgorithm.AES128_CBC;
        }
        if (symmAlg.equalsIgnoreCase("SM4")) {
            return CMSAlgorithm.SM4;
        }
        if (symmAlg.equalsIgnoreCase("DES")) {
            return CMSAlgorithm.DES_EDE3_CBC;
        }
        if (symmAlg.equalsIgnoreCase("3DES")) {
            return CMSAlgorithm.DES_EDE3_CBC;
        }
        throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET);
    }

    static {
        _extendedKeyUsageMap.clear();
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.1", "serverAuth");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.2", "clientAuth");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.3", "codeSigning");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.4", "emailProtection");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.5", "ipsecEndSystem");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.6", "ipsecTunnel");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.7", "ipsecUser");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.8", "timeStamping");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.9", "OCSPSigning");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.10", "dvcs");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.11", "sbgpCertAAServerAuth");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.12", "scvpResponder");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.13", "eapOverPPP");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.14", "eapOverLAN");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.15", "scvpServer");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.16", "scvpClient");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.17", "ipsecIKE");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.18", "capwapAC");
        _extendedKeyUsageMap.put("1.3.6.1.5.5.7.3.19", "capwapWTP");
        _extendedKeyUsageMap.put("1.3.6.1.4.1.311.20.2.2", "smartcardlogon");
    }
}

