/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.KeyStoreConfig;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import cn.topca.api.cert.VerifierConfig;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigMgr {
    private List<KeyStoreConfig> keyStoreConfigList = new ArrayList<KeyStoreConfig>();
    private List<VerifierConfig> verifierConfigList = new ArrayList<VerifierConfig>();
    private Map<String, String> globalConfig = new HashMap<String, String>();
    private String licenseStr = null;
    private static final ConfigMgr ConfigMgrInstance = new ConfigMgr();

    private ConfigMgr() {
    }

    public static synchronized ConfigMgr getInstance() {
        return ConfigMgrInstance;
    }

    public boolean init(String jsonStrConfig) throws CertApiException {
        try {
            JSONObject jsonObject = new JSONObject(jsonStrConfig);
            return this.init(jsonObject);
        }
        catch (JSONException e) {
            throw new CertApiException(TCAErrCode.ERR_JSON_PARSING, (Throwable)e);
        }
    }

    public boolean init(JSONObject jsonConfig) throws CertApiException {
        try {
            this.licenseStr = jsonConfig.getString("license");
            this.globalConfig = this.getGlobalConfig(jsonConfig);
            if (this.hasTrustCAConfig(jsonConfig)) {
                this.verifierConfigList = this.getVerifierConfigList(jsonConfig.getJSONArray("trustCA"));
            }
            if (this.hasKeyStoreConfig(jsonConfig)) {
                this.keyStoreConfigList = this.getKeyStoreConfigList(jsonConfig.getJSONArray("keyStore"));
            }
            return true;
        }
        catch (JSONException e) {
            throw new CertApiException(TCAErrCode.ERR_JSON_PARSING, (Throwable)e);
        }
    }

    public String getStrConfig(String key) {
        return this.globalConfig.get(key);
    }

    public boolean getBoolConfig(String key) {
        String val = this.getStrConfig(key);
        return "true".equalsIgnoreCase(val);
    }

    public String getLicenseStr() {
        return this.licenseStr;
    }

    public List<KeyStoreConfig> getKeyStoreConfigList() {
        return this.keyStoreConfigList;
    }

    public List<VerifierConfig> getVerifierConfigList() {
        return this.verifierConfigList;
    }

    private boolean hasKeyStoreConfig(JSONObject jsonConfig) {
        try {
            jsonConfig.getJSONArray("keyStore");
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private boolean hasTrustCAConfig(JSONObject jsonConfig) {
        try {
            jsonConfig.getJSONArray("trustCA");
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private Map<String, String> getGlobalConfig(JSONObject jsonConfig) throws JSONException {
        Iterator keys = jsonConfig.keys();
        HashMap<String, String> ret = new HashMap<String, String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.equalsIgnoreCase("license") || key.equalsIgnoreCase("trustCA") || key.equalsIgnoreCase("keystore")) continue;
            String value = jsonConfig.getString(key);
            ret.put(key, value);
        }
        return ret;
    }

    private int[] jsonArr2intArr(JSONArray jsonArray) throws JSONException {
        int[] ret = new int[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            int rp;
            ret[i] = rp = jsonArray.getInt(i);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<VerifierConfig> getVerifierConfigList(JSONArray trustCA) throws CertApiException {
        try {
            ArrayList<VerifierConfig> verifierList = new ArrayList<VerifierConfig>(trustCA.length());
            for (int i = 0; i < trustCA.length(); ++i) {
                VerifierConfig verifierConfig;
                X509Certificate caCert;
                JSONObject json = trustCA.getJSONObject(i);
                if (json.has("caCert")) {
                    caCert = TCAUtil.convB64Str2Cert(json.getString("caCert"));
                } else {
                    if (!json.has("caCertPath")) throw new CertApiException(TCAErrCode.ERR_NOFOUND_CACERT);
                    caCert = TCAUtil.readFile2Cert(json.getString("caCertPath"));
                }
                boolean checkRevoke = json.getBoolean("checkRevoke");
                if (checkRevoke) {
                    String baseUrl;
                    String checkMode = json.getString("checkMode");
                    if (checkMode.equalsIgnoreCase("ocsp")) {
                        String url = json.getString("url");
                        verifierConfig = VerifierConfig.genOCSPConfig(caCert, url);
                    } else if (checkMode.equalsIgnoreCase("crl")) {
                        baseUrl = json.getString("baseUrl");
                        String savePath = json.getString("savePath");
                        JSONArray retryPolicy = json.getJSONArray("retryPolicy");
                        int[] retryPolicyArr = this.jsonArr2intArr(retryPolicy);
                        verifierConfig = VerifierConfig.genCRLConfig(caCert, baseUrl, savePath, retryPolicyArr);
                    } else {
                        if (!checkMode.equalsIgnoreCase("crlex")) throw new CertApiException(TCAErrCode.ERR_UNKNOWN_VERIFYTYPE);
                        baseUrl = json.getString("baseUrl");
                        String deltaUrl = json.getString("deltaUrl");
                        String savePath = json.getString("savePath");
                        JSONArray retryPolicy = json.getJSONArray("retryPolicy");
                        int[] retryPolicyArr = this.jsonArr2intArr(retryPolicy);
                        verifierConfig = VerifierConfig.genCRLExConfig(caCert, baseUrl, deltaUrl, savePath, retryPolicyArr);
                    }
                } else {
                    verifierConfig = VerifierConfig.genNoRevokeConfig(caCert);
                }
                verifierList.add(verifierConfig);
            }
            return verifierList;
        }
        catch (JSONException e) {
            throw new CertApiException(TCAErrCode.ERR_JSON_PARSING, (Throwable)e);
        }
    }

    private List<KeyStoreConfig> getKeyStoreConfigList(JSONArray keyStoreJsonArr) throws CertApiException {
        try {
            ArrayList<KeyStoreConfig> keyStoreList = new ArrayList<KeyStoreConfig>(keyStoreJsonArr.length());
            ArrayList<String> names = new ArrayList<String>(keyStoreJsonArr.length());
            for (int j = 0; j < keyStoreJsonArr.length(); ++j) {
                JSONObject entry = keyStoreJsonArr.getJSONObject(j);
                String keyStoreName = entry.getString("name");
                if (names.contains(keyStoreName)) {
                    throw new CertApiException(TCAErrCode.ERR_DUPLICATE_KSNAME);
                }
                names.add(keyStoreName);
                String keyStoreType = entry.getString("type");
                if (keyStoreType.isEmpty()) {
                    keyStoreType = "JKS";
                }
                if (!keyStoreType.equalsIgnoreCase("JKS")) {
                    throw new CertApiException(TCAErrCode.ERR_UNSUP_KSTYPE);
                }
                KeyStoreConfig keyStoreBean = new KeyStoreConfig(keyStoreName, keyStoreType, entry.getString("provider"), entry.getString("keyStorePath"), entry.getString("password"));
                keyStoreList.add(keyStoreBean);
            }
            return keyStoreList;
        }
        catch (JSONException e) {
            throw new CertApiException(TCAErrCode.ERR_JSON_PARSING, (Throwable)e);
        }
    }
}

