/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.IKeyStoreProvider;
import cn.topca.api.cert.KeyStoreConfig;
import cn.topca.api.cert.KeyStoreProvider;
import cn.topca.api.cert.TCAErrCode;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyStoreMgr {
    private static final KeyStoreMgr keyStoreMgrInstance = new KeyStoreMgr();
    private List<KeyStoreConfig> configList = new ArrayList<KeyStoreConfig>();
    private Map<String, IKeyStoreProvider> providerMap = new HashMap<String, IKeyStoreProvider>();

    private KeyStoreMgr() {
    }

    public static synchronized KeyStoreMgr getInstance() {
        return keyStoreMgrInstance;
    }

    void init(List<KeyStoreConfig> configList) throws CertApiException {
        if (configList == null) {
            return;
        }
        if (configList.isEmpty()) {
            this.configList.clear();
            this.providerMap.clear();
            return;
        }
        HashMap<String, IKeyStoreProvider> tmpProviderMap = new HashMap<String, IKeyStoreProvider>();
        for (KeyStoreConfig config : configList) {
            tmpProviderMap.put(config.getName(), new KeyStoreProvider(config));
        }
        this.providerMap = tmpProviderMap;
        this.configList = configList;
    }

    public String[] listStoreNames() {
        Set<String> nameSet = this.providerMap.keySet();
        return nameSet.toArray(new String[nameSet.size()]);
    }

    public Certificate[] listCert(String name) throws CertApiException {
        IKeyStoreProvider provider = this.getProvider(name);
        return provider.listCerts();
    }

    public String genCSR(String name, String subject, String alg, int size, String hashAlg) throws CertApiException {
        IKeyStoreProvider provider = this.getProvider(name);
        return provider.genCSR(subject, alg, size, hashAlg);
    }

    public String genCSR(String name, Certificate cert) throws CertApiException {
        IKeyStoreProvider provider = this.providerMap.get(name);
        return provider.genCSR(cert);
    }

    public boolean importCert(Certificate cert, boolean alwaysImport) throws CertApiException {
        IKeyStoreProvider provider = this.getProvider(cert.getPublicKey());
        return provider.importCert(cert, alwaysImport);
    }

    public boolean importCertAndKey(String name, Certificate cert, KeyPair key) throws CertApiException {
        IKeyStoreProvider provider = this.getProvider(name);
        return provider.importCertAndKey(cert, key);
    }

    public PrivateKey getPriKeyByCert(String name, Certificate cert) throws CertApiException {
        IKeyStoreProvider provider = this.getProvider(name);
        PrivateKey privateKey = provider.getPriKeyByCert(cert);
        if (privateKey == null) {
            throw new CertApiException(TCAErrCode.ERR_NOFOUND_PRIKEY);
        }
        return privateKey;
    }

    public PrivateKey getPriKeyByCert(Certificate cert) throws CertApiException {
        String[] names;
        for (String name : names = this.listStoreNames()) {
            PrivateKey priKey = this.getPriKeyByCert(name, cert);
            if (priKey == null) continue;
            return priKey;
        }
        throw new CertApiException(TCAErrCode.ERR_NOFOUND_PRIKEY);
    }

    public String findNameByCert(Certificate cert) throws CertApiException {
        String[] names;
        for (String name : names = this.listStoreNames()) {
            if (this.getPriKeyByCert(name, cert) == null) continue;
            return name;
        }
        return null;
    }

    private IKeyStoreProvider getProvider(String name) throws CertApiException {
        IKeyStoreProvider provider = this.providerMap.get(name);
        if (provider == null) {
            throw new CertApiException(TCAErrCode.ERR_NOTFIND_PROVIDER);
        }
        return provider;
    }

    private IKeyStoreProvider getProvider(PublicKey pubKey) throws CertApiException {
        Set<String> names = this.providerMap.keySet();
        for (String name : names) {
            IKeyStoreProvider provider = this.providerMap.get(name);
            if (provider.getPriKeyByPubKey(pubKey) == null) continue;
            return provider;
        }
        throw new CertApiException(TCAErrCode.ERR_NOTFIND_PROVIDER);
    }
}

