/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cert.X509v3CertificateBuilder;
import cn.tca.TopBasicCrypto.operator.ContentSigner;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.IKeyStoreProvider;
import cn.topca.api.cert.KeyStoreConfig;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import cn.topca.core.ext.bc.pkcs.PKCS10OperatorUtils;
import cn.topca.core.ext.bc.util.KeyStoreUtils;
import cn.topca.security.bc.operator.JcaContentSignerBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.interfaces.DHKey;
import org.apache.commons.codec.binary.Hex;

class KeyStoreProvider
implements IKeyStoreProvider {
    private KeyStore keyStore;
    private KeyStoreConfig config;
    private static String stubOID = "1.2.3.4.5.6";

    public KeyStoreProvider(KeyStoreConfig config) throws CertApiException {
        this.config = config;
        this.config(config);
    }

    public String getName() {
        return this.config.getName();
    }

    public Certificate[] listCerts() throws CertApiException {
        return this.doListCerts(false);
    }

    public String genCSR(String subject, String alg, int size, String hashAlg) throws CertApiException {
        KeyPair key = this.genKey(alg, size);
        Certificate stubCert = this.genStubCert(key);
        this.importCertAndKey(stubCert, key);
        String ret = this.genCSR(subject, key, hashAlg);
        this.saveStore();
        return ret;
    }

    public String genCSR(Certificate cert) throws CertApiException {
        try {
            String alias = this.keyStore.getCertificateAlias(cert);
            PrivateKey priKey = (PrivateKey)this.keyStore.getKey(alias, this.config.getPwd());
            PublicKey pubKey = cert.getPublicKey();
            KeyPair keyPair = new KeyPair(pubKey, priKey);
            X509Certificate x509cert = TCAUtil.convBin2Cert(cert.getEncoded());
            String subject = ((Object)x509cert.getSubjectDN()).toString();
            String alg = pubKey.getAlgorithm();
            int size = 256;
            if (pubKey instanceof RSAKey) {
                size = ((RSAKey)((Object)pubKey)).getModulus().bitLength();
            } else if (pubKey instanceof DSAKey) {
                size = ((DSAKey)((Object)pubKey)).getParams().getP().bitLength();
            } else if (pubKey instanceof DHKey) {
                size = ((DHKey)((Object)pubKey)).getParams().getP().bitLength();
            } else if ("SM2".equals(pubKey.getAlgorithm())) {
                size = 256;
            }
            String hashAlg = size == 256 ? "SM3" : "SHA1";
            return this.genCSR(subject, keyPair, hashAlg);
        }
        catch (KeyStoreException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_BYKEYSTORE, (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_RECOVERABLEKEY, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_ENCODECERT, (Throwable)e);
        }
    }

    public boolean importCert(Certificate cert, boolean alwaysImport) throws CertApiException {
        Certificate[] certs;
        for (Certificate it : certs = this.doListCerts(true)) {
            if (!cert.getPublicKey().equals(it.getPublicKey())) continue;
            try {
                String alias = this.keyStore.getCertificateAlias(it);
                PrivateKey priKey = (PrivateKey)this.keyStore.getKey(alias, this.config.getPwd());
                this.keyStore.deleteEntry(alias);
                Certificate[] _certs = new Certificate[]{cert};
                this.keyStore.setKeyEntry(alias, priKey, this.config.getPwd(), _certs);
                this.saveStore();
                return true;
            }
            catch (KeyStoreException e) {
                throw new CertApiException(TCAErrCode.ERR_CERT_BYKEYSTORE, (Throwable)e);
            }
            catch (UnrecoverableKeyException e) {
                throw new CertApiException(TCAErrCode.ERR_BAD_RECOVERABLEKEY, (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
            }
        }
        if (!alwaysImport) {
            return false;
        }
        try {
            String alias = TCAUtil.genPubKeyHash(cert.getPublicKey());
            this.keyStore.setCertificateEntry(alias, cert);
        }
        catch (KeyStoreException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_BYKEYSTORE, (Throwable)e);
        }
        return true;
    }

    public boolean importCertAndKey(Certificate cert, KeyPair key) throws CertApiException {
        String alias = TCAUtil.genPubKeyHash(key.getPublic());
        Certificate[] certs = new Certificate[]{cert};
        try {
            this.keyStore.setKeyEntry(alias, key.getPrivate(), this.config.getPwd(), certs);
        }
        catch (KeyStoreException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_BYKEYSTORE, (Throwable)e);
        }
        this.saveStore();
        return true;
    }

    public PrivateKey getPriKeyByCert(Certificate cert) throws CertApiException {
        try {
            String alias = this.keyStore.getCertificateAlias(cert);
            return (PrivateKey)this.keyStore.getKey(alias, this.config.getPwd());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_BYKEYSTORE, (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_RECOVERABLEKEY, (Throwable)e);
        }
    }

    public PrivateKey getPriKeyByPubKey(PublicKey pubKey) throws CertApiException {
        Certificate[] certs;
        for (Certificate cert : certs = this.doListCerts(true)) {
            if (!cert.getPublicKey().equals(pubKey)) continue;
            return this.getPriKeyByCert(cert);
        }
        return null;
    }

    private void config(KeyStoreConfig config) throws CertApiException {
        try {
            this.keyStore = KeyStore.getInstance(config.getType(), TCAUtil.getSm2Provider());
            File file = new File(config.getUri());
            if (!file.exists()) {
                throw new CertApiException(TCAErrCode.ERR_NOFOUND_KEYSTORE);
            }
            FileInputStream is = new FileInputStream(file);
            this.keyStore.load(is, config.getPwd());
        }
        catch (KeyStoreException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_BYKEYSTORE, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
        catch (CertificateException e) {
            throw new CertApiException(TCAErrCode.ERR_LOAD_KEYSTORE, (Throwable)e);
        }
    }

    private KeyPair genKey(String alg, int size) throws CertApiException {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(alg);
            keyPairGen.initialize(size);
            return keyPairGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
    }

    private Certificate genStubCert(KeyPair key) throws CertApiException {
        byte[] pubKeyHash;
        Date notBefore = new Date();
        Date notAfter = new Date(notBefore.getTime() + 31536000000L + 10L);
        try {
            pubKeyHash = KeyStoreUtils.sha1PublicKey((PublicKey)key.getPublic());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        X500Name dn = new X500Name("CN=" + Hex.encodeHexString((byte[])pubKeyHash));
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(dn, new BigInteger(pubKeyHash), notBefore, notAfter, dn, SubjectPublicKeyInfo.getInstance((Object)key.getPublic().getEncoded()));
        builder.addExtension(new ASN1ObjectIdentifier(stubOID), false, (ASN1Encodable)new DERInteger(pubKeyHash));
        String signAlg = key.getPrivate().getAlgorithm().equals("SM2") ? "SM3withSM2" : "SHA1with" + key.getPrivate().getAlgorithm();
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signAlg);
        try {
            ContentSigner signer = signerBuilder.build(key.getPrivate());
            X509CertificateHolder holder = builder.build(signer);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return factory.generateCertificate(new ByteArrayInputStream(holder.getEncoded()));
        }
        catch (OperatorCreationException ignore) {
            throw new CertApiException(TCAErrCode.ERR_OPERATORCREATION, (Throwable)ignore);
        }
        catch (CertificateException e) {
            throw new CertApiException(TCAErrCode.ERR_CONV_CERT, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    private String genCSR(String subject, KeyPair keyPair, String hashAlg) throws CertApiException {
        try {
            String providerName = this.config.getProvider();
            if (providerName.isEmpty()) {
                providerName = keyPair.getPublic() instanceof ECKey ? "TopSM" : "BC";
            }
            return PKCS10OperatorUtils.genCSR((String)subject, (String)hashAlg, (KeyPair)keyPair, (String)providerName);
        }
        catch (InvalidKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PROVIDER, (Throwable)e);
        }
        catch (SignatureException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_SIGNATRUE, (Throwable)e);
        }
        catch (OperatorCreationException e) {
            throw new CertApiException(TCAErrCode.ERR_OPERATORCREATION, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    private void saveStore() throws CertApiException {
        try {
            FileOutputStream fos = new FileOutputStream(this.config.getUri());
            this.keyStore.store(fos, this.config.getPwd());
        }
        catch (KeyStoreException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_BYKEYSTORE, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (CertificateException e) {
            throw new CertApiException(TCAErrCode.ERR_CONV_CERT, (Throwable)e);
        }
    }

    private Certificate[] doListCerts(boolean needStubCert) throws CertApiException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            ArrayList<Certificate> certs = new ArrayList<Certificate>();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = this.keyStore.getCertificate(alias);
                X509Certificate x509cert = TCAUtil.convBin2Cert(cert.getEncoded());
                if (x509cert.getExtensionValue(stubOID) != null && !needStubCert) continue;
                certs.add(cert);
            }
            return certs.toArray(new Certificate[certs.size()]);
        }
        catch (KeyStoreException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_BYKEYSTORE, (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_ENCODECERT, (Throwable)e);
        }
    }
}

