/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.cms.AttributeTable;
import cn.tca.TopBasicCrypto.asn1.cms.CMSAttributes;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.TCADebugUtil;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import cn.topca.core.ext.bc.asn1.cms.CMSObjectIdentifiers;
import cn.topca.core.ext.bc.cms.CMSSignedData;
import cn.topca.core.ext.bc.cms.SignerInformation;
import cn.topca.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

class LicenseMgr {
    private static String licCert = "MIIDQDCCAuWgAwIBAgIUXyWc2syCu37zBbMAe4uOyb35tfIwDAYIKoEcz1UBg3UFADBVMSYwJAYDVQQDDB3lpKnor5rlronkv6HmtYvor5VTTTLnlKjmiLdDQTEOMAwGA1UECwwFVE9QQ0ExDjAMBgNVBAoMBVRPUENBMQswCQYDVQQGEwJDTjAeFw0xNDA5MjYwNzQ2MDhaFw0xNTA5MjYwNzQ2MDhaMDExGDAWBgNVBAMMD1NpZ25FU0EyMDE0MDkyNzEVMBMGA1UECgwM5aSp6K+a5a6J5L+hMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAElhZ4UuYjL2ZO535qLQsF4ujGGCc7odxAZuxCGXh+94nOhXHQLLO3/G9ZjnLuXeoDB3n0Bsj4iboW2X/AA5KFiaOCAbMwggGvMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgbAMIGKBggrBgEFBQcBAQR+MHwwegYIKwYBBQUHMAKGbmh0dHA6Ly9Zb3VyX1NlcnZlcl9OYW1lOlBvcnQvVG9wQ0EvdXNlckVucm9sbC9jYUNlcnQ/Y2VydFNlcmlhbE51bWJlcj01QTQ3RUNGMTA1ODA0QTVDNkE1QjIyOTI5Qjc1REYwREZCQzBENzk2MFcGA1UdLgRQME4wTKBKoEiGRlBvcnQvVG9wQ0EvcHVibGljL2l0cnVzY3JsP0NBPTVBNDdFQ0YxMDU4MDRBNUM2QTVCMjI5MjlCNzVERjBERkJDMEQ3OTYwbwYDVR0fBGgwZjBkoGKgYIZeaHR0cDovL1lvdXJfU2VydmVyX05hbWU6UG9ydC9Ub3BDQS9wdWJsaWMvaXRydXNjcmw/Q0E9NUE0N0VDRjEwNTgwNEE1QzZBNUIyMjkyOUI3NURGMERGQkMwRDc5NjAfBgNVHSMEGDAWgBQ9icZHy3GFsNk71kiwidnn/u/a2TAdBgNVHQ4EFgQUSzvtf4eChoegEpKxLuYAJdi1EQAwDAYIKoEcz1UBg3UFAANHADBEAiC9tNcXzI0fmOxsbqvtcvksS6kl3yXzH1qTPyuE7ldhggIg6D6HGfkXjg3n7Bqob7UNuzqb3GIgPzdWQeeam10yhHs=";
    private static String licRule;
    private static final LicenseMgr LicenseConfigInstance;

    private LicenseMgr() {
        licRule = null;
    }

    public static synchronized LicenseMgr getInstance() {
        return LicenseConfigInstance;
    }

    private JSONObject verifyLicense(String b64License) throws CertApiException {
        byte[] plaintext = null;
        byte[] data = TCAUtil.decode(b64License);
        ASN1ObjectIdentifier pkcs7Type = null;
        CMSSignedData cmsSignedData = null;
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)data);
        ASN1ObjectIdentifier contentType = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        if (contentType.equals((Object)CMSObjectIdentifiers.signedData) || contentType.equals((Object)CMSObjectIdentifiers.gm_signedData)) {
            pkcs7Type = PKCSObjectIdentifiers.signedData;
            try {
                cmsSignedData = new CMSSignedData(data);
            }
            catch (CMSException e) {
                throw new CertApiException(TCAErrCode.ERR_CMS_BADSIGN, (Throwable)e);
            }
        } else {
            throw new CertApiException(TCAErrCode.ERR_CONTENTTYPE);
        }
        if (cmsSignedData.getSignedContent() == null) {
            throw new CertApiException(TCAErrCode.ERR_PKCS7_VERIFY_NOPLAIN);
        }
        plaintext = (byte[])cmsSignedData.getSignedContent().getContent();
        ArrayList signerInfoList = (ArrayList)cmsSignedData.getSignerInfos().getSigners();
        if (signerInfoList.size() == 0) {
            throw new CertApiException(TCAErrCode.ERR_PKCS7_NOSIGNER);
        }
        X509Certificate cert = TCAUtil.convB64Str2Cert(licCert);
        PublicKey pubKey = cert.getPublicKey();
        for (int i = 0; i < signerInfoList.size(); ++i) {
            Signature sig;
            String hashAlg;
            String pubKeyAlg;
            SignerInformation signerInfo = (SignerInformation)signerInfoList.get(i);
            String string = pubKeyAlg = pubKey.getAlgorithm().equalsIgnoreCase("SM2") ? "SM2" : "RSA";
            if (signerInfo.getDigestAlgOID().equals(AlgorithmId.SM3_oid.toString())) {
                hashAlg = "SM3";
            } else if (signerInfo.getDigestAlgOID().equals(AlgorithmId.SHA_oid.toString())) {
                hashAlg = "SHA1";
            } else if (signerInfo.getDigestAlgOID().equals(AlgorithmId.SHA256_oid.toString())) {
                hashAlg = "SHA256";
            } else {
                throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET);
            }
            String signAlg = hashAlg + "With" + pubKeyAlg;
            try {
                sig = pubKeyAlg.equalsIgnoreCase("SM2") ? Signature.getInstance(signAlg, TCAUtil.getSm2Provider()) : Signature.getInstance(signAlg, TCAUtil.getBcProvider());
                sig.initVerify(pubKey);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
            }
            catch (InvalidKeyException e) {
                throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
            }
            byte[] verifyPlain = plaintext;
            if (signerInfo.getSignedAttributes() != null) {
                byte[] plainHash;
                AttributeTable authAttrs = signerInfo.getSignedAttributes();
                if (authAttrs.size() != 3) {
                    throw new CertApiException(TCAErrCode.ERR_PKCS7_ATTR_ERR);
                }
                if (authAttrs.get((DERObjectIdentifier)CMSAttributes.contentType) == null) {
                    throw new CertApiException(TCAErrCode.ERR_PKCS7_NOFOUND_CT);
                }
                if (authAttrs.get((DERObjectIdentifier)CMSAttributes.signingTime) == null) {
                    throw new CertApiException(TCAErrCode.ERR_PKCS7_NOFOUND_ST);
                }
                if (authAttrs.get((DERObjectIdentifier)CMSAttributes.messageDigest) == null) {
                    throw new CertApiException(TCAErrCode.ERR_PKCS7_NOFOUND_MD);
                }
                DEROctetString octString = (DEROctetString)signerInfo.getSignedAttributes().get((DERObjectIdentifier)CMSAttributes.messageDigest).getAttrValues().getObjectAt(0);
                byte[] messageDigest = octString.getOctets();
                authAttrs.get((DERObjectIdentifier)CMSAttributes.messageDigest).getAttrValues().getObjectAt(0).getDERObject().toASN1Object();
                if (hashAlg.equalsIgnoreCase("SM3")) {
                    plainHash = TCAUtil.SM3(plaintext);
                } else if (hashAlg.equalsIgnoreCase("SHA1")) {
                    plainHash = TCAUtil.SHA1(plaintext);
                } else if (hashAlg.equalsIgnoreCase("SHA256")) {
                    plainHash = TCAUtil.SHA256(plaintext);
                } else {
                    throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET);
                }
                if (!Arrays.equals(messageDigest, plainHash)) {
                    throw new CertApiException(TCAErrCode.ERR_PKCS7_MD_VERIFY);
                }
                try {
                    verifyPlain = signerInfo.getEncodedSignedAttributes();
                }
                catch (IOException e) {
                    throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
                }
            }
            try {
                sig.update(verifyPlain);
                if (!sig.verify(signerInfo.getSignature())) continue;
                return new JSONObject(new String(plaintext, "UTF-8"));
            }
            catch (SignatureException e) {
                throw new CertApiException(TCAErrCode.ERR_PKCS7_VERIFY_FAILD, (Throwable)e);
            }
            catch (JSONException e) {
                throw new CertApiException(TCAErrCode.ERR_JSON_PARSING, (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new CertApiException(TCAErrCode.ERR_ENCODE, (Throwable)e);
            }
        }
        return null;
    }

    private boolean isValidLicense(JSONObject licenseJson) throws CertApiException {
        Date notBefore;
        Date notAfter;
        String licRuleStr;
        String softVersionStr;
        String notAfterStr;
        String notBeforeStr;
        try {
            notBeforeStr = licenseJson.getString("notbefore");
            notAfterStr = licenseJson.getString("notafter");
            softVersionStr = licenseJson.getString("softVersion");
            licRuleStr = licenseJson.getString("Issuer");
        }
        catch (JSONException e) {
            throw new CertApiException(TCAErrCode.ERR_JSON_PARSING, (Throwable)e);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            notAfter = sdf.parse(notAfterStr);
            notBefore = sdf.parse(notBeforeStr);
        }
        catch (ParseException e) {
            throw new CertApiException(TCAErrCode.ERR_DATE_FORMAT, (Throwable)e);
        }
        Date now = new Date();
        if (now.before(notBefore) || now.after(notAfter)) {
            throw new CertApiException(TCAErrCode.ERR_LICENSE_EXPIRE);
        }
        if (!softVersionStr.startsWith("3.1.0.0".substring(0, 3))) {
            throw new CertApiException(TCAErrCode.ERR_LICENSE_BADVER);
        }
        licRule = TCADebugUtil.isDebug() ? ".*" : licRuleStr;
        return true;
    }

    public boolean init(String b64License) throws CertApiException {
        JSONObject json = this.verifyLicense(b64License);
        if (json == null) {
            throw new CertApiException(TCAErrCode.ERR_JSON_PARSING);
        }
        return this.isValidLicense(json);
    }

    public boolean certWithLicense(X509Certificate cert) {
        return cert.getIssuerX500Principal().toString().matches(licRule);
    }

    public boolean certWithLicense(Certificate cert) throws CertApiException {
        try {
            X509Certificate c = TCAUtil.convBin2Cert(cert.getEncoded());
            return c.getIssuerX500Principal().toString().matches(licRule);
        }
        catch (CertificateEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_ENCODING, (Throwable)e);
        }
    }

    static {
        LicenseConfigInstance = new LicenseMgr();
    }
}

