/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.cms.AttributeTable;
import cn.tca.TopBasicCrypto.asn1.cms.CMSAttributes;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.Recipient;
import cn.tca.TopBasicCrypto.cms.SignerId;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.CertSet;
import cn.topca.api.cert.CertStore;
import cn.topca.api.cert.Certificate;
import cn.topca.api.cert.KeyStoreMgr;
import cn.topca.api.cert.LicenseMgr;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import cn.topca.core.ext.bc.asn1.cms.CMSObjectIdentifiers;
import cn.topca.core.ext.bc.cms.CMSEnvelopedData;
import cn.topca.core.ext.bc.cms.CMSSignedData;
import cn.topca.core.ext.bc.cms.RecipientInformation;
import cn.topca.core.ext.bc.cms.SignerInformation;
import cn.topca.core.ext.bc.cms.jcajce.JceKeyTransEnvelopedRecipient;
import cn.topca.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;

public class Pkcs7 {
    private ASN1ObjectIdentifier pkcs7Type;
    private CMSEnvelopedData cmsEnvelopedData;
    private CMSSignedData cmsSignedData;
    private static final String h1 = "-----BEGIN PKCS7-----";
    private static final String e1 = "-----END PKCS7-----";
    private static LicenseMgr licMgr = LicenseMgr.getInstance();
    private static KeyStoreMgr keyMgr = KeyStoreMgr.getInstance();

    public Pkcs7(String b64Pkcs7) throws CertApiException {
        if (b64Pkcs7.contains(h1)) {
            b64Pkcs7 = b64Pkcs7.replaceAll(h1, "").replaceAll(e1, "");
        }
        this.init(TCAUtil.decode(b64Pkcs7));
    }

    public Pkcs7(byte[] binPkcs7) throws CertApiException {
        this.init(binPkcs7);
    }

    private void init(byte[] data) throws CertApiException {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)data);
        ASN1ObjectIdentifier contentType = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        if (contentType.equals((Object)CMSObjectIdentifiers.signedData) || contentType.equals((Object)CMSObjectIdentifiers.gm_signedData)) {
            this.pkcs7Type = PKCSObjectIdentifiers.signedData;
            try {
                this.cmsSignedData = new CMSSignedData(data);
            }
            catch (CMSException e) {
                throw new CertApiException(TCAErrCode.ERR_CMS_BADSIGN, (Throwable)e);
            }
        } else if (contentType.equals((Object)CMSObjectIdentifiers.envelopedData) || contentType.equals((Object)CMSObjectIdentifiers.gm_envelopedData)) {
            this.pkcs7Type = PKCSObjectIdentifiers.encryptedData;
            try {
                this.cmsEnvelopedData = new CMSEnvelopedData(data);
            }
            catch (CMSException e) {
                throw new CertApiException(TCAErrCode.ERR_GENERATE_ENVELOPDATA, (Throwable)e);
            }
        } else {
            if (contentType.equals((Object)CMSObjectIdentifiers.signedAndEnvelopedData) || contentType.equals((Object)CMSObjectIdentifiers.gm_signedAndEnvelopedData)) {
                throw new CertApiException(TCAErrCode.ERR_CONTENTTYPE);
            }
            if (contentType.equals((Object)CMSObjectIdentifiers.digestedData) || contentType.equals((Object)CMSObjectIdentifiers.gm_digestedData)) {
                throw new CertApiException(TCAErrCode.ERR_CONTENTTYPE);
            }
            if (contentType.equals((Object)CMSObjectIdentifiers.encryptedData) || contentType.equals((Object)CMSObjectIdentifiers.gm_encryptedData)) {
                throw new CertApiException(TCAErrCode.ERR_CONTENTTYPE);
            }
            throw new CertApiException(TCAErrCode.ERR_CONTENTTYPE);
        }
    }

    public byte[] contentMessage() throws CertApiException {
        if (!this.pkcs7Type.equals((Object)PKCSObjectIdentifiers.signedData)) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PKCS7TYPE);
        }
        if (this.cmsSignedData.getSignedContent() == null) {
            return null;
        }
        return (byte[])this.cmsSignedData.getSignedContent().getContent();
    }

    public Certificate verify() throws CertApiException {
        if (!this.pkcs7Type.equals((Object)PKCSObjectIdentifiers.signedData)) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PKCS7TYPE);
        }
        byte[] binPlain = this.contentMessage();
        ArrayList certList = this.doGetCerts();
        return this.doVerify(binPlain, certList);
    }

    public Certificate verify(byte[] binPlain) throws CertApiException {
        if (!this.pkcs7Type.equals((Object)PKCSObjectIdentifiers.signedData)) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PKCS7TYPE);
        }
        ArrayList certList = this.doGetCerts();
        return this.doVerify(binPlain, certList);
    }

    public byte[] decryptMessage() throws CertApiException {
        if (!this.pkcs7Type.equals((Object)PKCSObjectIdentifiers.encryptedData)) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PKCS7TYPE);
        }
        ArrayList recipientInfoList = (ArrayList)this.cmsEnvelopedData.getRecipientInfos().getRecipients();
        if (recipientInfoList.size() == 0) {
            throw new CertApiException(TCAErrCode.ERR_PKCS7_NORECIPIENT);
        }
        CertSet allCerts = CertStore.listAllCerts();
        if (allCerts.size() == 0) {
            throw new CertApiException(TCAErrCode.ERR_PKCS7_DECRYPT_NOCERT);
        }
        for (Object aRecipientInfoList : recipientInfoList) {
            RecipientInformation recipientInfo = (RecipientInformation)aRecipientInfoList;
            String certSN = Hex.encodeHexString((byte[])recipientInfo.getRID().getSerialNumber().toByteArray()).toUpperCase();
            String certIssuer = recipientInfo.getRID().getIssuer().toString();
            CertSet decCerts = allCerts.bySerialnumber(certSN).byIssuer(certIssuer);
            if (decCerts.size() == 0) continue;
            X509Certificate x509Cert = TCAUtil.convB64Str2Cert(decCerts.get(0).toBase64());
            if (!licMgr.certWithLicense(x509Cert)) {
                throw new CertApiException(TCAErrCode.ERR_CERT_UNLIC);
            }
            PrivateKey priKey = keyMgr.getPriKeyByCert(x509Cert);
            JceKeyTransEnvelopedRecipient keyTransEnvelopedRecipient = new JceKeyTransEnvelopedRecipient(priKey);
            try {
                return recipientInfo.getContent((Recipient)keyTransEnvelopedRecipient);
            }
            catch (CMSException e) {
                throw new CertApiException(TCAErrCode.ERR_DEC_PKCS7, (Throwable)e);
            }
        }
        return null;
    }

    public CertSet getCerts() throws CertApiException {
        if (!this.pkcs7Type.equals((Object)PKCSObjectIdentifiers.signedData)) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PKCS7TYPE);
        }
        ArrayList certList = this.doGetCerts();
        Certificate[] retCerts = new Certificate[certList.size()];
        for (int i = 0; i < certList.size(); ++i) {
            X509CertificateHolder certHolder = (X509CertificateHolder)certList.get(0);
            try {
                retCerts[i] = new Certificate(certHolder.getEncoded());
                continue;
            }
            catch (IOException e) {
                throw new CertApiException(TCAErrCode.ERR_CONV_CERT, (Throwable)e);
            }
        }
        return new CertSet(retCerts);
    }

    private Certificate doVerify(byte[] binPlain, ArrayList certList) throws CertApiException {
        if (binPlain == null) {
            throw new CertApiException(TCAErrCode.ERR_PKCS7_VERIFY_NOPLAIN);
        }
        if (certList == null || certList.size() == 0) {
            throw new CertApiException(TCAErrCode.ERR_PKCS7_VERIFY_NOCERT);
        }
        ArrayList signerInfoList = (ArrayList)this.cmsSignedData.getSignerInfos().getSigners();
        if (signerInfoList.size() == 0) {
            throw new CertApiException(TCAErrCode.ERR_PKCS7_NOSIGNER);
        }
        for (int i = 0; i < signerInfoList.size(); ++i) {
            SignerInformation signerInfo = (SignerInformation)signerInfoList.get(0);
            SignerId sid = signerInfo.getSID();
            for (int j = 0; j < certList.size(); ++j) {
                X509CertificateHolder certHolder = (X509CertificateHolder)certList.get(0);
                if (!sid.match((Object)certHolder)) continue;
                try {
                    X509Certificate cert = TCAUtil.convBin2Cert(certHolder.getEncoded());
                    if (!this.verifySignerInfo(binPlain, signerInfo, cert.getPublicKey())) continue;
                    return new Certificate(cert.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    throw new CertApiException(TCAErrCode.ERR_ENCODECERT, (Throwable)e);
                }
                catch (IOException e) {
                    throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
                }
            }
        }
        return null;
    }

    private boolean verifySignerInfo(byte[] binPlain, SignerInformation signerInfo, PublicKey pubKey) throws CertApiException {
        Signature sig;
        String hashAlg;
        String pubKeyAlg;
        String string = pubKeyAlg = pubKey.getAlgorithm().equalsIgnoreCase("SM2") ? "SM2" : "RSA";
        if (signerInfo.getDigestAlgOID().equals(AlgorithmId.SM3_oid.toString())) {
            hashAlg = "SM3";
        } else if (signerInfo.getDigestAlgOID().equals(AlgorithmId.SHA_oid.toString())) {
            hashAlg = "SHA1";
        } else if (signerInfo.getDigestAlgOID().equals(AlgorithmId.SHA256_oid.toString())) {
            hashAlg = "SHA256";
        } else {
            throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET);
        }
        String signAlg = hashAlg + "With" + pubKeyAlg;
        try {
            sig = pubKeyAlg.equalsIgnoreCase("SM2") ? Signature.getInstance(signAlg, TCAUtil.getSm2Provider()) : Signature.getInstance(signAlg, TCAUtil.getBcProvider());
            sig.initVerify(pubKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
        }
        byte[] verifyPlain = binPlain;
        if (signerInfo.getSignedAttributes() != null) {
            byte[] plainHash;
            AttributeTable authAttrs = signerInfo.getSignedAttributes();
            if (authAttrs.size() != 3) {
                throw new CertApiException(TCAErrCode.ERR_PKCS7_ATTR_ERR);
            }
            if (authAttrs.get((DERObjectIdentifier)CMSAttributes.contentType) == null) {
                throw new CertApiException(TCAErrCode.ERR_PKCS7_NOFOUND_CT);
            }
            if (authAttrs.get((DERObjectIdentifier)CMSAttributes.signingTime) == null) {
                throw new CertApiException(TCAErrCode.ERR_PKCS7_NOFOUND_ST);
            }
            if (authAttrs.get((DERObjectIdentifier)CMSAttributes.messageDigest) == null) {
                throw new CertApiException(TCAErrCode.ERR_PKCS7_NOFOUND_MD);
            }
            DEROctetString octString = (DEROctetString)signerInfo.getSignedAttributes().get((DERObjectIdentifier)CMSAttributes.messageDigest).getAttrValues().getObjectAt(0);
            byte[] messageDigest = octString.getOctets();
            authAttrs.get((DERObjectIdentifier)CMSAttributes.messageDigest).getAttrValues().getObjectAt(0).getDERObject().toASN1Object();
            if (hashAlg.equalsIgnoreCase("SM3")) {
                plainHash = TCAUtil.SM3(binPlain);
            } else if (hashAlg.equalsIgnoreCase("SHA1")) {
                plainHash = TCAUtil.SHA1(binPlain);
            } else if (hashAlg.equalsIgnoreCase("SHA256")) {
                plainHash = TCAUtil.SHA256(binPlain);
            } else {
                throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET);
            }
            if (!Arrays.equals(messageDigest, plainHash)) {
                throw new CertApiException(TCAErrCode.ERR_PKCS7_MD_VERIFY);
            }
            try {
                verifyPlain = signerInfo.getEncodedSignedAttributes();
            }
            catch (IOException e) {
                throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
            }
        }
        try {
            sig.update(verifyPlain);
            return sig.verify(signerInfo.getSignature());
        }
        catch (SignatureException e) {
            throw new CertApiException(TCAErrCode.ERR_PKCS7_VERIFY_FAILD, (Throwable)e);
        }
    }

    private ArrayList doGetCerts() {
        return (ArrayList)this.cmsSignedData.getCertificates().getMatches(null);
    }
}

