/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.ocsp.CertID;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.jce.X509Principal;
import cn.tca.TopBasicCrypto.ocsp.CertificateID;
import cn.tca.TopBasicCrypto.ocsp.OCSPException;
import cn.topca.security.x509.AlgorithmId;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;

class TCACertID
extends CertificateID {
    public TCACertID(CertID certID) {
        super(certID);
    }

    public TCACertID(String hashAlgorithm, X509Certificate issuerCert, BigInteger serialNumber, String providerName) throws OCSPException {
        super(hashAlgorithm, issuerCert, serialNumber, providerName);
    }

    public TCACertID(String hashAlgorithm, X509Certificate issuerCert, BigInteger serialNumber) throws OCSPException {
        super(hashAlgorithm, issuerCert, serialNumber);
    }

    public TCACertID(AlgorithmId algorithmId, X509Principal issuerDn, byte[] publicKeyData, BigInteger serialNumber) {
        super(TCACertID.createCertID(algorithmId, issuerDn.getEncoded(), publicKeyData, serialNumber, "BC"));
    }

    public TCACertID(AlgorithmId algorithmId, byte[] issuerDn, byte[] publicKeyData, BigInteger serialNumber) {
        super(TCACertID.createCertID(algorithmId, issuerDn, publicKeyData, serialNumber, "BC"));
    }

    private static CertID createCertID(AlgorithmId algorithmId, byte[] issuerDn, byte[] publicKeyData, BigInteger serialNumber, String s) {
        try {
            AlgorithmIdentifier algorithmidentifier = new AlgorithmIdentifier(new DERObjectIdentifier(algorithmId.getOID().toString()), (DEREncodable)DERNull.INSTANCE);
            MessageDigest messagedigest = MessageDigest.getInstance(algorithmId.getName(), s);
            messagedigest.update(issuerDn);
            DEROctetString issuerHash = new DEROctetString(messagedigest.digest());
            messagedigest.update(publicKeyData);
            DEROctetString keyHash = new DEROctetString(messagedigest.digest());
            return new CertID(algorithmidentifier, (ASN1OctetString)issuerHash, (ASN1OctetString)keyHash, new DERInteger(serialNumber));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

