/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.topca.api.cert.CertApiException;
import java.security.cert.X509Certificate;

class VerifierConfig {
    public static final int TYPE_NOREVOKE = 0;
    public static final int TYPE_CRL = 1;
    public static final int TYPE_CRL_EX = 2;
    public static final int TYPE_OCSP = 3;
    private int type;
    private X509Certificate caCert;
    private String name;
    private String baseCrlUrl;
    private String deltaCrlUrl;
    private String savePath;
    private String ocspUrl;
    private boolean checkRevoke;
    private int[] retryPolicy;

    public static VerifierConfig genNoRevokeConfig(X509Certificate caCert) throws CertApiException {
        VerifierConfig ret = new VerifierConfig();
        ret.type = 0;
        ret.caCert = caCert;
        ret.name = ret.caCert.getSubjectX500Principal().toString();
        ret.checkRevoke = false;
        return ret;
    }

    public static VerifierConfig genOCSPConfig(X509Certificate caCert, String ocspUrl) throws CertApiException {
        VerifierConfig ret = new VerifierConfig();
        ret.type = 3;
        ret.caCert = caCert;
        ret.name = ret.caCert.getSubjectX500Principal().toString();
        ret.checkRevoke = true;
        ret.ocspUrl = ocspUrl;
        return ret;
    }

    public static VerifierConfig genCRLConfig(X509Certificate caCert, String baseUrl, String savePath, int[] retryPolicy) throws CertApiException {
        VerifierConfig ret = new VerifierConfig();
        ret.type = 1;
        ret.caCert = caCert;
        ret.name = ret.caCert.getSubjectX500Principal().toString();
        ret.checkRevoke = true;
        ret.baseCrlUrl = baseUrl;
        ret.savePath = savePath;
        ret.retryPolicy = retryPolicy;
        return ret;
    }

    public static VerifierConfig genCRLExConfig(X509Certificate caCert, String baseUrl, String deltaUrl, String savePath, int[] retryPolicy) throws CertApiException {
        VerifierConfig ret = new VerifierConfig();
        ret.type = 2;
        ret.caCert = caCert;
        ret.name = ret.caCert.getSubjectX500Principal().toString();
        ret.checkRevoke = true;
        ret.baseCrlUrl = baseUrl;
        ret.deltaCrlUrl = deltaUrl;
        ret.savePath = savePath;
        ret.retryPolicy = retryPolicy;
        return ret;
    }

    private VerifierConfig() {
    }

    public int getType() {
        return this.type;
    }

    public X509Certificate getCaCert() {
        return this.caCert;
    }

    public String getBaseCrlUrl() {
        return this.baseCrlUrl;
    }

    public String getDeltaCrlUrl() {
        return this.deltaCrlUrl;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public String getOcspUrl() {
        return this.ocspUrl;
    }

    public boolean isCheckRevoke() {
        return this.checkRevoke;
    }

    public int[] getRetryPolicy() {
        return this.retryPolicy;
    }

    public String getName() {
        return this.name;
    }
}

