/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.cache.filter;

import kd.bos.krpc.cache.Cache;
import kd.bos.krpc.cache.CacheFactory;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.utils.ConfigUtils;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.RpcResult;

@Activate(group={"consumer", "provider"}, value={"cache"})
public class CacheFilter
implements Filter {
    private CacheFactory cacheFactory;

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Cache cache;
        if (this.cacheFactory != null && ConfigUtils.isNotEmpty(invoker.getUrl().getMethodParameter(invocation.getMethodName(), "cache")) && (cache = this.cacheFactory.getCache(invoker.getUrl().addParameter("method", invocation.getMethodName()))) != null) {
            String key = StringUtils.toArgumentString(invocation.getArguments());
            if (cache != null && key != null) {
                Object value = cache.get(key);
                if (value != null) {
                    return new RpcResult(value);
                }
                Result result = invoker.invoke(invocation);
                if (!result.hasException()) {
                    cache.put(key, result.getValue());
                }
                return result;
            }
        }
        return invoker.invoke(invocation);
    }
}

