/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.config.spring.status;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Map;
import javax.sql.DataSource;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.status.Status;
import kd.bos.krpc.common.status.StatusChecker;
import kd.bos.krpc.config.spring.ServiceBean;
import org.springframework.context.ApplicationContext;

@Activate
public class DataSourceStatusChecker
implements StatusChecker {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceStatusChecker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status check() {
        ApplicationContext context = ServiceBean.getSpringContext();
        if (context == null) {
            return new Status(Status.Level.UNKNOWN);
        }
        Map dataSources = context.getBeansOfType(DataSource.class, false, false);
        if (dataSources == null || dataSources.size() == 0) {
            return new Status(Status.Level.UNKNOWN);
        }
        Status.Level level = Status.Level.OK;
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : dataSources.entrySet()) {
            DataSource dataSource = (DataSource)entry.getValue();
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append((String)entry.getKey());
            try (Connection connection = dataSource.getConnection();){
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getTypeInfo();){
                    if (!resultSet.next()) {
                        level = Status.Level.ERROR;
                    }
                }
                buf.append(metaData.getURL());
                buf.append("(");
                buf.append(metaData.getDatabaseProductName());
                buf.append("-");
                buf.append(metaData.getDatabaseProductVersion());
                buf.append(")");
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                return new Status(level, e.getMessage());
            }
        }
        return new Status(level, buf.toString());
    }
}

