/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.container.javaconfig;

import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.utils.ConfigUtils;
import kd.bos.krpc.container.Container;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class JavaConfigContainer
implements Container {
    private static final Logger logger = LoggerFactory.getLogger(JavaConfigContainer.class);
    public static final String SPRING_JAVACONFIG = "dubbo.spring.javaconfig";
    public static final String DEFAULT_SPRING_JAVACONFIG = "dubbo.spring.javaconfig";
    static AnnotationConfigApplicationContext context;

    public static AnnotationConfigApplicationContext getContext() {
        return context;
    }

    @Override
    public void start() {
        String configPath = ConfigUtils.getProperty("dubbo.spring.javaconfig");
        if (configPath == null || configPath.length() == 0) {
            configPath = "dubbo.spring.javaconfig";
        }
        context = new AnnotationConfigApplicationContext(new String[]{configPath});
        context.start();
    }

    @Override
    public void stop() {
        try {
            if (context != null) {
                context.stop();
                context.close();
                context = null;
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }
}

