/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.container.page.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.common.status.Status;
import kd.bos.krpc.common.status.StatusChecker;
import kd.bos.krpc.common.status.support.StatusUtils;
import kd.bos.krpc.container.page.Menu;
import kd.bos.krpc.container.page.Page;
import kd.bos.krpc.container.page.PageHandler;

@Menu(name="Status", desc="Show system status.", order=2147471647)
public class StatusPageHandler
implements PageHandler {
    @Override
    public Page handle(URL url) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        Set<String> names = ExtensionLoader.getExtensionLoader(StatusChecker.class).getSupportedExtensions();
        HashMap<String, Status> statuses = new HashMap<String, Status>();
        for (String name : names) {
            StatusChecker checker = ExtensionLoader.getExtensionLoader(StatusChecker.class).getExtension(name);
            ArrayList<String> row = new ArrayList<String>();
            row.add(name);
            Status status = checker.check();
            if (status == null || Status.Level.UNKNOWN.equals((Object)status.getLevel())) continue;
            statuses.put(name, status);
            row.add(this.getLevelHtml(status.getLevel()));
            row.add(status.getMessage());
            rows.add(row);
        }
        Status status = StatusUtils.getSummaryStatus(statuses);
        if ("status".equals(url.getPath())) {
            return new Page("", "", "", status.getLevel().toString());
        }
        ArrayList<String> row = new ArrayList<String>();
        row.add("summary");
        row.add(this.getLevelHtml(status.getLevel()));
        row.add("<a href=\"/status\" target=\"_blank\">summary</a>");
        rows.add(row);
        return new Page("Status (<a href=\"/status\" target=\"_blank\">summary</a>)", "Status", new String[]{"Name", "Status", "Description"}, rows);
    }

    private String getLevelHtml(Status.Level level) {
        return "<font color=\"" + this.getLevelColor(level) + "\">" + level.name() + "</font>";
    }

    private String getLevelColor(Status.Level level) {
        if (level == Status.Level.OK) {
            return "green";
        }
        if (level == Status.Level.ERROR) {
            return "red";
        }
        if (level == Status.Level.WARN) {
            return "yellow";
        }
        return "gray";
    }
}

