/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.monitor.support;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.utils.NetUtils;
import kd.bos.krpc.monitor.Monitor;
import kd.bos.krpc.monitor.MonitorFactory;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcContext;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.support.RpcUtils;

@Activate(group={"provider", "consumer"})
public class MonitorFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(MonitorFilter.class);
    private final ConcurrentMap<String, AtomicInteger> concurrents = new ConcurrentHashMap<String, AtomicInteger>();
    private MonitorFactory monitorFactory;

    public void setMonitorFactory(MonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (invoker.getUrl().hasParameter("monitor")) {
            RpcContext context = RpcContext.getContext();
            long start = System.currentTimeMillis();
            this.getConcurrent(invoker, invocation).incrementAndGet();
            try {
                Result result = invoker.invoke(invocation);
                this.collect(invoker, invocation, result, context, start, false);
                Result result2 = result;
                return result2;
            }
            catch (RpcException e) {
                this.collect(invoker, invocation, null, context, start, true);
                throw e;
            }
            finally {
                this.getConcurrent(invoker, invocation).decrementAndGet();
            }
        }
        return invoker.invoke(invocation);
    }

    private void collect(Invoker<?> invoker, Invocation invocation, Result result, RpcContext context, long start, boolean error) {
        try {
            String remoteValue;
            String remoteKey;
            int localPort;
            long elapsed = System.currentTimeMillis() - start;
            int concurrent = this.getConcurrent(invoker, invocation).get();
            String application = invoker.getUrl().getParameter("application");
            String service = invoker.getInterface().getName();
            String method = RpcUtils.getMethodName(invocation);
            URL url = invoker.getUrl().getUrlParameter("monitor");
            Monitor monitor = this.monitorFactory.getMonitor(url);
            if ("consumer".equals(invoker.getUrl().getParameter("side"))) {
                context = RpcContext.getContext();
                localPort = 0;
                remoteKey = "provider";
                remoteValue = invoker.getUrl().getAddress();
            } else {
                localPort = invoker.getUrl().getPort();
                remoteKey = "consumer";
                remoteValue = context.getRemoteHost();
            }
            String input = "";
            String output = "";
            if (invocation.getAttachment("input") != null) {
                input = invocation.getAttachment("input");
            }
            if (result != null && result.getAttachment("output") != null) {
                output = result.getAttachment("output");
            }
            monitor.collect(new URL("count", NetUtils.getLocalHost(), localPort, service + "/" + method, "application", application, "interface", service, "method", method, remoteKey, remoteValue, error ? "failure" : "success", "1", "elapsed", String.valueOf(elapsed), "concurrent", String.valueOf(concurrent), "input", input, "output", output));
        }
        catch (Throwable t) {
            logger.error("Failed to monitor count service " + invoker.getUrl() + ", cause: " + t.getMessage(), t);
        }
    }

    private AtomicInteger getConcurrent(Invoker<?> invoker, Invocation invocation) {
        String key = invoker.getInterface().getName() + "." + invocation.getMethodName();
        AtomicInteger concurrent = (AtomicInteger)this.concurrents.get(key);
        if (concurrent == null) {
            this.concurrents.putIfAbsent(key, new AtomicInteger());
            concurrent = (AtomicInteger)this.concurrents.get(key);
        }
        return concurrent;
    }
}

