/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.registry.integration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.krpc.common.Constants;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.utils.NetUtils;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.common.utils.UrlUtils;
import kd.bos.krpc.registry.NotifyListener;
import kd.bos.krpc.registry.Registry;
import kd.bos.krpc.registry.RegistryFactory;
import kd.bos.krpc.registry.RegistryService;
import kd.bos.krpc.registry.integration.RegistryDirectory;
import kd.bos.krpc.rpc.Exporter;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Protocol;
import kd.bos.krpc.rpc.ProxyFactory;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.cluster.Cluster;
import kd.bos.krpc.rpc.cluster.Configurator;
import kd.bos.krpc.rpc.protocol.InvokerWrapper;

public class RegistryProtocol
implements Protocol {
    private Cluster cluster;
    private Protocol protocol;
    private RegistryFactory registryFactory;
    private ProxyFactory proxyFactory;
    private static RegistryProtocol INSTANCE;
    private final Map<URL, NotifyListener> overrideListeners = new ConcurrentHashMap<URL, NotifyListener>();
    private final Map<String, ExporterChangeableWrapper<?>> bounds = new ConcurrentHashMap();
    private static final Logger logger;

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRegistryFactory(RegistryFactory registryFactory) {
        this.registryFactory = registryFactory;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public int getDefaultPort() {
        return 9090;
    }

    public RegistryProtocol() {
        INSTANCE = this;
    }

    public static RegistryProtocol getRegistryProtocol() {
        if (INSTANCE == null) {
            ExtensionLoader.getExtensionLoader(Protocol.class).getExtension("registry");
        }
        return INSTANCE;
    }

    public Map<URL, NotifyListener> getOverrideListeners() {
        return this.overrideListeners;
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> originInvoker) throws RpcException {
        final ExporterChangeableWrapper<T> exporter = this.doLocalExport(originInvoker);
        final Registry registry = this.getRegistry(originInvoker);
        final URL registedProviderUrl = this.getRegistedProviderUrl(originInvoker);
        registry.register(registedProviderUrl);
        final URL overrideSubscribeUrl = this.getSubscribedOverrideUrl(registedProviderUrl);
        final OverrideListener overrideSubscribeListener = new OverrideListener(overrideSubscribeUrl);
        this.overrideListeners.put(overrideSubscribeUrl, overrideSubscribeListener);
        registry.subscribe(overrideSubscribeUrl, overrideSubscribeListener);
        return new Exporter<T>(){

            @Override
            public Invoker<T> getInvoker() {
                return exporter.getInvoker();
            }

            @Override
            public void unexport() {
                try {
                    exporter.unexport();
                }
                catch (Throwable t) {
                    logger.warn(t.getMessage(), t);
                }
                try {
                    registry.unregister(registedProviderUrl);
                }
                catch (Throwable t) {
                    logger.warn(t.getMessage(), t);
                }
                try {
                    RegistryProtocol.this.overrideListeners.remove(overrideSubscribeUrl);
                    registry.unsubscribe(overrideSubscribeUrl, overrideSubscribeListener);
                }
                catch (Throwable t) {
                    logger.warn(t.getMessage(), t);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ExporterChangeableWrapper<T> doLocalExport(Invoker<T> originInvoker) {
        String key = this.getCacheKey(originInvoker);
        ExporterChangeableWrapper<Object> exporter = this.bounds.get(key);
        if (exporter == null) {
            Map<String, ExporterChangeableWrapper<?>> map = this.bounds;
            synchronized (map) {
                exporter = this.bounds.get(key);
                if (exporter == null) {
                    InvokerDelegete<T> invokerDelegete = new InvokerDelegete<T>(originInvoker, this.getProviderUrl(originInvoker));
                    exporter = new ExporterChangeableWrapper<T>(this.protocol.export(invokerDelegete), originInvoker);
                    this.bounds.put(key, exporter);
                }
            }
        }
        return exporter;
    }

    private <T> void doChangeLocalExport(Invoker<T> originInvoker, URL newInvokerUrl) {
        String key = this.getCacheKey(originInvoker);
        ExporterChangeableWrapper<?> exporter = this.bounds.get(key);
        if (exporter == null) {
            logger.warn(new IllegalStateException("error state, exporter should not be null"));
            return;
        }
        InvokerDelegete<T> invokerDelegete = new InvokerDelegete<T>(originInvoker, newInvokerUrl);
        exporter.setExporter(this.protocol.export(invokerDelegete));
    }

    private Registry getRegistry(Invoker<?> originInvoker) {
        URL registryUrl = originInvoker.getUrl();
        if ("registry".equals(registryUrl.getProtocol())) {
            String protocol = registryUrl.getParameter("registry", "dubbo");
            registryUrl = registryUrl.setProtocol(protocol).removeParameter("registry");
        }
        return this.registryFactory.getRegistry(registryUrl);
    }

    private URL getRegistedProviderUrl(Invoker<?> originInvoker) {
        URL providerUrl = this.getProviderUrl(originInvoker);
        URL registedProviderUrl = providerUrl.removeParameters(RegistryProtocol.getFilteredKeys(providerUrl)).removeParameter("monitor");
        return registedProviderUrl;
    }

    private URL getSubscribedOverrideUrl(URL registedProviderUrl) {
        return registedProviderUrl.setProtocol("provider").addParameters("category", "configurators", "check", String.valueOf(false));
    }

    private URL getProviderUrl(Invoker<?> origininvoker) {
        String export = origininvoker.getUrl().getParameterAndDecoded("export");
        if (export == null || export.length() == 0) {
            throw new IllegalArgumentException("The registry export url is null! registry: " + origininvoker.getUrl());
        }
        URL providerUrl = URL.valueOf(export);
        return providerUrl;
    }

    private String getCacheKey(Invoker<?> originInvoker) {
        URL providerUrl = this.getProviderUrl(originInvoker);
        String key = providerUrl.removeParameters("dynamic", "enabled").toFullString();
        return key;
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        url = url.setProtocol(url.getParameter("registry", "dubbo")).removeParameter("registry");
        Registry registry = this.registryFactory.getRegistry(url);
        if (RegistryService.class.equals(type)) {
            return this.proxyFactory.getInvoker(registry, type, url);
        }
        Map<String, String> qs = StringUtils.parseQueryString(url.getParameterAndDecoded("refer"));
        String group = qs.get("group");
        if (group != null && group.length() > 0 && (Constants.COMMA_SPLIT_PATTERN.split(group).length > 1 || "*".equals(group))) {
            return this.doRefer(this.getMergeableCluster(), registry, type, url);
        }
        return this.doRefer(this.cluster, registry, type, url);
    }

    private Cluster getMergeableCluster() {
        return ExtensionLoader.getExtensionLoader(Cluster.class).getExtension("mergeable");
    }

    private <T> Invoker<T> doRefer(Cluster cluster, Registry registry, Class<T> type, URL url) {
        RegistryDirectory<T> directory = new RegistryDirectory<T>(type, url);
        directory.setRegistry(registry);
        directory.setProtocol(this.protocol);
        URL subscribeUrl = new URL("consumer", NetUtils.getLocalHost(), 0, type.getName(), directory.getUrl().getParameters());
        if (!"*".equals(url.getServiceInterface()) && url.getParameter("register", true)) {
            registry.register(subscribeUrl.addParameters("category", "consumers", "check", String.valueOf(false)));
        }
        directory.subscribe(subscribeUrl.addParameter("category", "providers,configurators,routers"));
        return cluster.join(directory);
    }

    private static String[] getFilteredKeys(URL url) {
        Map<String, String> params = url.getParameters();
        if (params != null && !params.isEmpty()) {
            ArrayList<String> filteredKeys = new ArrayList<String>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (entry == null || entry.getKey() == null || !entry.getKey().startsWith(".")) continue;
                filteredKeys.add(entry.getKey());
            }
            return filteredKeys.toArray(new String[filteredKeys.size()]);
        }
        return new String[0];
    }

    @Override
    public void destroy() {
        ArrayList exporters = new ArrayList(this.bounds.values());
        for (Exporter exporter : exporters) {
            exporter.unexport();
        }
        this.bounds.clear();
    }

    static {
        logger = LoggerFactory.getLogger(RegistryProtocol.class);
    }

    private class ExporterChangeableWrapper<T>
    implements Exporter<T> {
        private Exporter<T> exporter;
        private final Invoker<T> originInvoker;

        public ExporterChangeableWrapper(Exporter<T> exporter, Invoker<T> originInvoker) {
            this.exporter = exporter;
            this.originInvoker = originInvoker;
        }

        public Invoker<T> getOriginInvoker() {
            return this.originInvoker;
        }

        @Override
        public Invoker<T> getInvoker() {
            return this.exporter.getInvoker();
        }

        public void setExporter(Exporter<T> exporter) {
            this.exporter = exporter;
        }

        @Override
        public void unexport() {
            String key = RegistryProtocol.this.getCacheKey(this.originInvoker);
            RegistryProtocol.this.bounds.remove(key);
            this.exporter.unexport();
        }
    }

    public static class InvokerDelegete<T>
    extends InvokerWrapper<T> {
        private final Invoker<T> invoker;

        public InvokerDelegete(Invoker<T> invoker, URL url) {
            super(invoker, url);
            this.invoker = invoker;
        }

        public Invoker<T> getInvoker() {
            if (this.invoker instanceof InvokerDelegete) {
                return ((InvokerDelegete)this.invoker).getInvoker();
            }
            return this.invoker;
        }
    }

    private class OverrideListener
    implements NotifyListener {
        private volatile List<Configurator> configurators;
        private final URL subscribeUrl;

        public OverrideListener(URL subscribeUrl) {
            this.subscribeUrl = subscribeUrl;
        }

        @Override
        public void notify(List<URL> urls) {
            ArrayList<URL> result = null;
            Iterator<URL> iterator = urls.iterator();
            while (iterator.hasNext()) {
                URL url;
                URL overrideUrl = url = iterator.next();
                if (url.getParameter("category") == null && "override".equals(url.getProtocol())) {
                    overrideUrl = url.addParameter("category", "configurators");
                }
                if (UrlUtils.isMatch(this.subscribeUrl, overrideUrl)) continue;
                if (result == null) {
                    result = new ArrayList<URL>(urls);
                }
                result.remove(url);
                logger.warn("Subsribe category=configurator, but notifed non-configurator urls. may be registry bug. unexcepted url: " + url);
            }
            if (result != null) {
                urls = result;
            }
            this.configurators = RegistryDirectory.toConfigurators(urls);
            ArrayList exporters = new ArrayList(RegistryProtocol.this.bounds.values());
            for (ExporterChangeableWrapper exporter : exporters) {
                URL newUrl;
                Invoker invoker = exporter.getOriginInvoker();
                Invoker originInvoker = invoker instanceof InvokerDelegete ? ((InvokerDelegete)invoker).getInvoker() : invoker;
                URL originUrl = RegistryProtocol.this.getProviderUrl(originInvoker);
                if (originUrl.equals(newUrl = this.getNewInvokerUrl(originUrl, urls))) continue;
                RegistryProtocol.this.doChangeLocalExport(originInvoker, newUrl);
            }
        }

        private URL getNewInvokerUrl(URL url, List<URL> urls) {
            List<Configurator> localConfigurators = this.configurators;
            if (localConfigurators != null && localConfigurators.size() > 0) {
                for (Configurator configurator : localConfigurators) {
                    url = configurator.configure(url);
                }
            }
            return url;
        }
    }
}

