/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.registry.status;

import java.util.Collection;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.status.Status;
import kd.bos.krpc.common.status.StatusChecker;
import kd.bos.krpc.registry.Registry;
import kd.bos.krpc.registry.support.AbstractRegistryFactory;

@Activate
public class RegistryStatusChecker
implements StatusChecker {
    @Override
    public Status check() {
        Collection<Registry> regsitries = AbstractRegistryFactory.getRegistries();
        if (regsitries == null || regsitries.size() == 0) {
            return new Status(Status.Level.UNKNOWN);
        }
        Status.Level level = Status.Level.OK;
        StringBuilder buf = new StringBuilder();
        for (Registry registry : regsitries) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(registry.getUrl().getAddress());
            if (!registry.isAvailable()) {
                level = Status.Level.ERROR;
                buf.append("(disconnected)");
                continue;
            }
            buf.append("(connected)");
        }
        return new Status(level, buf.toString());
    }
}

