/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting;

import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.Version;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.remoting.ChannelHandler;
import kd.bos.krpc.remoting.Client;
import kd.bos.krpc.remoting.RemotingException;
import kd.bos.krpc.remoting.Server;
import kd.bos.krpc.remoting.Transporter;
import kd.bos.krpc.remoting.transport.ChannelHandlerAdapter;
import kd.bos.krpc.remoting.transport.ChannelHandlerDispatcher;

public class Transporters {
    public static Server bind(String url, ChannelHandler ... handler) throws RemotingException {
        return Transporters.bind(URL.valueOf(url), handler);
    }

    public static Server bind(URL url, ChannelHandler ... handlers) throws RemotingException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handlers == null || handlers.length == 0) {
            throw new IllegalArgumentException("handlers == null");
        }
        ChannelHandler handler = handlers.length == 1 ? handlers[0] : new ChannelHandlerDispatcher(handlers);
        return Transporters.getTransporter().bind(url, handler);
    }

    public static Client connect(String url, ChannelHandler ... handler) throws RemotingException {
        return Transporters.connect(URL.valueOf(url), handler);
    }

    public static Client connect(URL url, ChannelHandler ... handlers) throws RemotingException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        ChannelHandler handler = handlers == null || handlers.length == 0 ? new ChannelHandlerAdapter() : (handlers.length == 1 ? handlers[0] : new ChannelHandlerDispatcher(handlers));
        return Transporters.getTransporter().connect(url, handler);
    }

    public static Transporter getTransporter() {
        return ExtensionLoader.getExtensionLoader(Transporter.class).getAdaptiveExtension();
    }

    private Transporters() {
    }

    static {
        Version.checkDuplicate(Transporters.class);
        Version.checkDuplicate(RemotingException.class);
    }
}

