/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting.exchange;

import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.Version;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.remoting.ChannelHandler;
import kd.bos.krpc.remoting.RemotingException;
import kd.bos.krpc.remoting.exchange.ExchangeClient;
import kd.bos.krpc.remoting.exchange.ExchangeHandler;
import kd.bos.krpc.remoting.exchange.ExchangeServer;
import kd.bos.krpc.remoting.exchange.Exchanger;
import kd.bos.krpc.remoting.exchange.support.ExchangeHandlerDispatcher;
import kd.bos.krpc.remoting.exchange.support.Replier;
import kd.bos.krpc.remoting.transport.ChannelHandlerAdapter;

public class Exchangers {
    public static ExchangeServer bind(String url, Replier<?> replier) throws RemotingException {
        return Exchangers.bind(URL.valueOf(url), replier);
    }

    public static ExchangeServer bind(URL url, Replier<?> replier) throws RemotingException {
        return Exchangers.bind(url, (ChannelHandler)new ChannelHandlerAdapter(), replier);
    }

    public static ExchangeServer bind(String url, ChannelHandler handler, Replier<?> replier) throws RemotingException {
        return Exchangers.bind(URL.valueOf(url), handler, replier);
    }

    public static ExchangeServer bind(URL url, ChannelHandler handler, Replier<?> replier) throws RemotingException {
        return Exchangers.bind(url, (ExchangeHandler)new ExchangeHandlerDispatcher(replier, handler));
    }

    public static ExchangeServer bind(String url, ExchangeHandler handler) throws RemotingException {
        return Exchangers.bind(URL.valueOf(url), handler);
    }

    public static ExchangeServer bind(URL url, ExchangeHandler handler) throws RemotingException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        url = url.addParameterIfAbsent("codec", "exchange");
        return Exchangers.getExchanger(url).bind(url, handler);
    }

    public static ExchangeClient connect(String url) throws RemotingException {
        return Exchangers.connect(URL.valueOf(url));
    }

    public static ExchangeClient connect(URL url) throws RemotingException {
        return Exchangers.connect(url, (ChannelHandler)new ChannelHandlerAdapter(), null);
    }

    public static ExchangeClient connect(String url, Replier<?> replier) throws RemotingException {
        return Exchangers.connect(URL.valueOf(url), (ChannelHandler)new ChannelHandlerAdapter(), replier);
    }

    public static ExchangeClient connect(URL url, Replier<?> replier) throws RemotingException {
        return Exchangers.connect(url, (ChannelHandler)new ChannelHandlerAdapter(), replier);
    }

    public static ExchangeClient connect(String url, ChannelHandler handler, Replier<?> replier) throws RemotingException {
        return Exchangers.connect(URL.valueOf(url), handler, replier);
    }

    public static ExchangeClient connect(URL url, ChannelHandler handler, Replier<?> replier) throws RemotingException {
        return Exchangers.connect(url, (ExchangeHandler)new ExchangeHandlerDispatcher(replier, handler));
    }

    public static ExchangeClient connect(String url, ExchangeHandler handler) throws RemotingException {
        return Exchangers.connect(URL.valueOf(url), handler);
    }

    public static ExchangeClient connect(URL url, ExchangeHandler handler) throws RemotingException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        url = url.addParameterIfAbsent("codec", "exchange");
        return Exchangers.getExchanger(url).connect(url, handler);
    }

    public static Exchanger getExchanger(URL url) {
        String type = url.getParameter("exchanger", "header");
        return Exchangers.getExchanger(type);
    }

    public static Exchanger getExchanger(String type) {
        return ExtensionLoader.getExtensionLoader(Exchanger.class).getExtension(type);
    }

    private Exchangers() {
    }

    static {
        Version.checkDuplicate(Exchangers.class);
    }
}

