/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting.exchange.support.header;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.krpc.common.Parameters;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.utils.NamedThreadFactory;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.ChannelHandler;
import kd.bos.krpc.remoting.Client;
import kd.bos.krpc.remoting.RemotingException;
import kd.bos.krpc.remoting.exchange.ExchangeChannel;
import kd.bos.krpc.remoting.exchange.ExchangeClient;
import kd.bos.krpc.remoting.exchange.ExchangeHandler;
import kd.bos.krpc.remoting.exchange.ResponseFuture;
import kd.bos.krpc.remoting.exchange.support.header.HeaderExchangeChannel;
import kd.bos.krpc.remoting.exchange.support.header.HeartBeatTask;

public class HeaderExchangeClient
implements ExchangeClient {
    private static final Logger logger = LoggerFactory.getLogger(HeaderExchangeClient.class);
    private static final ScheduledThreadPoolExecutor scheduled = new ScheduledThreadPoolExecutor(2, new NamedThreadFactory("dubbo-remoting-client-heartbeat", true));
    private ScheduledFuture<?> heatbeatTimer;
    private int heartbeat;
    private int heartbeatTimeout;
    private final Client client;
    private final ExchangeChannel channel;

    public HeaderExchangeClient(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("client == null");
        }
        this.client = client;
        this.channel = new HeaderExchangeChannel(client);
        String dubbo = client.getUrl().getParameter("dubbo");
        this.heartbeat = client.getUrl().getParameter("heartbeat", dubbo != null && dubbo.startsWith("1.0.") ? 60000 : 0);
        this.heartbeatTimeout = client.getUrl().getParameter("heartbeat.timeout", this.heartbeat * 3);
        if (this.heartbeatTimeout < this.heartbeat * 2) {
            throw new IllegalStateException("heartbeatTimeout < heartbeatInterval * 2");
        }
        this.startHeatbeatTimer();
    }

    @Override
    public ResponseFuture request(Object request) throws RemotingException {
        return this.channel.request(request);
    }

    @Override
    public URL getUrl() {
        return this.channel.getUrl();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    @Override
    public ResponseFuture request(Object request, int timeout) throws RemotingException {
        return this.channel.request(request, timeout);
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this.channel.getChannelHandler();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public ExchangeHandler getExchangeHandler() {
        return this.channel.getExchangeHandler();
    }

    @Override
    public void send(Object message) throws RemotingException {
        this.channel.send(message);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        this.channel.send(message, sent);
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    public void close() {
        this.doClose();
        this.channel.close();
    }

    @Override
    public void close(int timeout) {
        this.doClose();
        this.channel.close(timeout);
    }

    @Override
    public void reset(URL url) {
        this.client.reset(url);
    }

    @Override
    @Deprecated
    public void reset(Parameters parameters) {
        this.reset(this.getUrl().addParameters(parameters.getParameters()));
    }

    @Override
    public void reconnect() throws RemotingException {
        this.client.reconnect();
    }

    @Override
    public Object getAttribute(String key) {
        return this.channel.getAttribute(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.channel.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.channel.removeAttribute(key);
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.channel.hasAttribute(key);
    }

    private void startHeatbeatTimer() {
        this.stopHeartbeatTimer();
        if (this.heartbeat > 0) {
            this.heatbeatTimer = scheduled.scheduleWithFixedDelay(new HeartBeatTask(new HeartBeatTask.ChannelProvider(){

                @Override
                public Collection<Channel> getChannels() {
                    return Collections.singletonList(HeaderExchangeClient.this);
                }
            }, this.heartbeat, this.heartbeatTimeout), this.heartbeat, this.heartbeat, TimeUnit.MILLISECONDS);
        }
    }

    private void stopHeartbeatTimer() {
        block3: {
            if (this.heatbeatTimer != null && !this.heatbeatTimer.isCancelled()) {
                try {
                    this.heatbeatTimer.cancel(true);
                    scheduled.purge();
                }
                catch (Throwable e) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn(e.getMessage(), e);
                }
            }
        }
        this.heatbeatTimer = null;
    }

    private void doClose() {
        this.stopHeartbeatTimer();
    }

    public String toString() {
        return "HeaderExchangeClient [channel=" + this.channel + "]";
    }
}

