/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.serialize.Serialization;
import kd.bos.krpc.common.utils.NetUtils;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.Codec2;
import kd.bos.krpc.remoting.transport.CodecSupport;

public abstract class AbstractCodec
implements Codec2 {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCodec.class);

    protected Serialization getSerialization(Channel channel) {
        return CodecSupport.getSerialization(channel.getUrl());
    }

    protected static void checkPayload(Channel channel, long size) throws IOException {
        int payload = 0x800000;
        if (channel != null && channel.getUrl() != null) {
            payload = channel.getUrl().getParameter("payload", 0x800000);
        }
        if (payload > 0 && size > (long)payload) {
            IOException e = new IOException("Data length too large: " + size + ", max payload: " + payload + ", channel: " + channel);
            logger.error(e);
            throw e;
        }
    }

    protected boolean isClientSide(Channel channel) {
        String side = (String)channel.getAttribute("side");
        if ("client".equals(side)) {
            return true;
        }
        if ("server".equals(side)) {
            return false;
        }
        InetSocketAddress address = channel.getRemoteAddress();
        URL url = channel.getUrl();
        boolean client = url.getPort() == address.getPort() && NetUtils.filterLocalHost(url.getIp()).equals(NetUtils.filterLocalHost(address.getAddress().getHostAddress()));
        channel.setAttribute("side", client ? "client" : "server");
        return client;
    }

    protected boolean isServerSide(Channel channel) {
        return !this.isClientSide(channel);
    }
}

