/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting.transport;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.serialize.Serialization;

public class CodecSupport {
    private static final Logger logger = LoggerFactory.getLogger(CodecSupport.class);
    private static Map<Byte, Serialization> ID_SERIALIZATION_MAP = new HashMap<Byte, Serialization>();

    private CodecSupport() {
    }

    public static Serialization getSerializationById(Byte id) {
        return ID_SERIALIZATION_MAP.get(id);
    }

    public static Serialization getSerialization(URL url) {
        return ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(url.getParameter("serialization", "hessian2"));
    }

    public static Serialization getSerialization(URL url, Byte id) {
        Serialization result = CodecSupport.getSerializationById(id);
        if (result == null) {
            result = CodecSupport.getSerialization(url);
        }
        return result;
    }

    static {
        Set<String> supportedExtensions = ExtensionLoader.getExtensionLoader(Serialization.class).getSupportedExtensions();
        for (String name : supportedExtensions) {
            Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(name);
            byte idByte = serialization.getContentTypeId();
            if (ID_SERIALIZATION_MAP.containsKey(idByte)) {
                logger.error("Serialization extension " + serialization.getClass().getName() + " has duplicate id to Serialization extension " + ID_SERIALIZATION_MAP.get(idByte).getClass().getName() + ", ignore this Serialization extension");
                continue;
            }
            ID_SERIALIZATION_MAP.put(idByte, serialization);
        }
    }
}

