/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting.transport;

import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.ChannelHandler;
import kd.bos.krpc.remoting.Decodeable;
import kd.bos.krpc.remoting.RemotingException;
import kd.bos.krpc.remoting.exchange.Request;
import kd.bos.krpc.remoting.exchange.Response;
import kd.bos.krpc.remoting.transport.AbstractChannelHandlerDelegate;

public class DecodeHandler
extends AbstractChannelHandlerDelegate {
    private static final Logger log = LoggerFactory.getLogger(DecodeHandler.class);

    public DecodeHandler(ChannelHandler handler) {
        super(handler);
    }

    @Override
    public void received(Channel channel, Object message) throws RemotingException {
        if (message instanceof Decodeable) {
            this.decode(message);
        }
        if (message instanceof Request) {
            this.decode(((Request)message).getData());
        }
        if (message instanceof Response) {
            this.decode(((Response)message).getResult());
        }
        this.handler.received(channel, message);
    }

    private void decode(Object message) {
        block4: {
            if (message != null && message instanceof Decodeable) {
                try {
                    ((Decodeable)message).decode();
                    if (log.isDebugEnabled()) {
                        log.debug(new StringBuilder(32).append("Decode decodeable message ").append(message.getClass().getName()).toString());
                    }
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn(new StringBuilder(32).append("Call Decodeable.decode failed: ").append(e.getMessage()).toString(), e);
                }
            }
        }
    }
}

