/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting.transport.codec;

import java.io.IOException;
import kd.bos.krpc.common.io.UnsafeByteArrayInputStream;
import kd.bos.krpc.common.io.UnsafeByteArrayOutputStream;
import kd.bos.krpc.common.utils.Assert;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.Codec;
import kd.bos.krpc.remoting.Codec2;
import kd.bos.krpc.remoting.buffer.ChannelBuffer;

public class CodecAdapter
implements Codec2 {
    private Codec codec;

    public CodecAdapter(Codec codec) {
        Assert.notNull(codec, "codec == null");
        this.codec = codec;
    }

    @Override
    public void encode(Channel channel, ChannelBuffer buffer, Object message) throws IOException {
        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream(1024);
        this.codec.encode(channel, os, message);
        buffer.writeBytes(os.toByteArray());
    }

    @Override
    public Object decode(Channel channel, ChannelBuffer buffer) throws IOException {
        byte[] bytes = new byte[buffer.readableBytes()];
        int savedReaderIndex = buffer.readerIndex();
        buffer.readBytes(bytes);
        UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(bytes);
        Object result = this.codec.decode(channel, is);
        buffer.readerIndex(savedReaderIndex + is.position());
        return result == Codec.NEED_MORE_INPUT ? Codec2.DecodeResult.NEED_MORE_INPUT : result;
    }

    public Codec getCodec() {
        return this.codec;
    }
}

