/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting.transport.codec;

import java.io.IOException;
import kd.bos.krpc.common.serialize.Cleanable;
import kd.bos.krpc.common.serialize.ObjectInput;
import kd.bos.krpc.common.serialize.ObjectOutput;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.buffer.ChannelBuffer;
import kd.bos.krpc.remoting.buffer.ChannelBufferInputStream;
import kd.bos.krpc.remoting.buffer.ChannelBufferOutputStream;
import kd.bos.krpc.remoting.transport.AbstractCodec;

public class TransportCodec
extends AbstractCodec {
    @Override
    public void encode(Channel channel, ChannelBuffer buffer, Object message) throws IOException {
        ChannelBufferOutputStream output = new ChannelBufferOutputStream(buffer);
        ObjectOutput objectOutput = this.getSerialization(channel).serialize(channel.getUrl(), output);
        this.encodeData(channel, objectOutput, message);
        objectOutput.flushBuffer();
        if (objectOutput instanceof Cleanable) {
            ((Cleanable)((Object)objectOutput)).cleanup();
        }
    }

    @Override
    public Object decode(Channel channel, ChannelBuffer buffer) throws IOException {
        ChannelBufferInputStream input = new ChannelBufferInputStream(buffer);
        ObjectInput objectInput = this.getSerialization(channel).deserialize(channel.getUrl(), input);
        Object object = this.decodeData(channel, objectInput);
        if (objectInput instanceof Cleanable) {
            ((Cleanable)((Object)objectInput)).cleanup();
        }
        return object;
    }

    protected void encodeData(Channel channel, ObjectOutput output, Object message) throws IOException {
        this.encodeData(output, message);
    }

    protected Object decodeData(Channel channel, ObjectInput input) throws IOException {
        return this.decodeData(input);
    }

    protected void encodeData(ObjectOutput output, Object message) throws IOException {
        output.writeObject(message);
    }

    protected Object decodeData(ObjectInput input) throws IOException {
        try {
            return input.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException: " + StringUtils.toString(e));
        }
    }
}

