/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting.transport.dispatcher;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kd.bos.krpc.common.Constants;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.store.DataStore;
import kd.bos.krpc.common.threadpool.ThreadPool;
import kd.bos.krpc.common.utils.NamedThreadFactory;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.ChannelHandler;
import kd.bos.krpc.remoting.RemotingException;
import kd.bos.krpc.remoting.transport.ChannelHandlerDelegate;

public class WrappedChannelHandler
implements ChannelHandlerDelegate {
    protected static final Logger logger = LoggerFactory.getLogger(WrappedChannelHandler.class);
    protected static final ExecutorService SHARED_EXECUTOR = Executors.newCachedThreadPool(new NamedThreadFactory("DubboSharedHandler", true));
    protected final ExecutorService executor;
    protected final ChannelHandler handler;
    protected final URL url;

    public WrappedChannelHandler(ChannelHandler handler, URL url) {
        this.handler = handler;
        this.url = url;
        this.executor = (ExecutorService)ExtensionLoader.getExtensionLoader(ThreadPool.class).getAdaptiveExtension().getExecutor(url);
        String componentKey = Constants.EXECUTOR_SERVICE_COMPONENT_KEY;
        if ("consumer".equalsIgnoreCase(url.getParameter("side"))) {
            componentKey = "consumer";
        }
        DataStore dataStore = ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
        dataStore.put(componentKey, Integer.toString(url.getPort()), this.executor);
    }

    public void close() {
        try {
            if (this.executor instanceof ExecutorService) {
                this.executor.shutdown();
            }
        }
        catch (Throwable t) {
            logger.warn("fail to destroy thread pool of server: " + t.getMessage(), t);
        }
    }

    @Override
    public void connected(Channel channel) throws RemotingException {
        this.handler.connected(channel);
    }

    @Override
    public void disconnected(Channel channel) throws RemotingException {
        this.handler.disconnected(channel);
    }

    @Override
    public void sent(Channel channel, Object message) throws RemotingException {
        this.handler.sent(channel, message);
    }

    @Override
    public void received(Channel channel, Object message) throws RemotingException {
        this.handler.received(channel, message);
    }

    @Override
    public void caught(Channel channel, Throwable exception) throws RemotingException {
        this.handler.caught(channel, exception);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public ChannelHandler getHandler() {
        if (this.handler instanceof ChannelHandlerDelegate) {
            return ((ChannelHandlerDelegate)this.handler).getHandler();
        }
        return this.handler;
    }

    public URL getUrl() {
        return this.url;
    }
}

