/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.remoting.transport.dispatcher.all;

import java.util.concurrent.ExecutorService;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.remoting.Channel;
import kd.bos.krpc.remoting.ChannelHandler;
import kd.bos.krpc.remoting.ExecutionException;
import kd.bos.krpc.remoting.RemotingException;
import kd.bos.krpc.remoting.transport.dispatcher.ChannelEventRunnable;
import kd.bos.krpc.remoting.transport.dispatcher.WrappedChannelHandler;

public class AllChannelHandler
extends WrappedChannelHandler {
    public AllChannelHandler(ChannelHandler handler, URL url) {
        super(handler, url);
    }

    @Override
    public void connected(Channel channel) throws RemotingException {
        ExecutorService cexecutor = this.getExecutorService();
        try {
            cexecutor.execute(new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.CONNECTED));
        }
        catch (Throwable t) {
            throw new ExecutionException((Object)"connect event", channel, this.getClass() + " error when process connected event .", t);
        }
    }

    @Override
    public void disconnected(Channel channel) throws RemotingException {
        ExecutorService cexecutor = this.getExecutorService();
        try {
            cexecutor.execute(new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.DISCONNECTED));
        }
        catch (Throwable t) {
            throw new ExecutionException((Object)"disconnect event", channel, this.getClass() + " error when process disconnected event .", t);
        }
    }

    @Override
    public void received(Channel channel, Object message) throws RemotingException {
        ExecutorService cexecutor = this.getExecutorService();
        try {
            cexecutor.execute(new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.RECEIVED, message));
        }
        catch (Throwable t) {
            throw new ExecutionException(message, channel, this.getClass() + " error when process received event .", t);
        }
    }

    @Override
    public void caught(Channel channel, Throwable exception) throws RemotingException {
        ExecutorService cexecutor = this.getExecutorService();
        try {
            cexecutor.execute(new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.CAUGHT, exception));
        }
        catch (Throwable t) {
            throw new ExecutionException((Object)"caught event", channel, this.getClass() + " error when process caught event .", t);
        }
    }

    private ExecutorService getExecutorService() {
        ExecutorService cexecutor = this.executor;
        if (cexecutor == null || cexecutor.isShutdown()) {
            cexecutor = SHARED_EXECUTOR;
        }
        return cexecutor;
    }
}

