/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.cluster.directory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.cluster.Directory;
import kd.bos.krpc.rpc.cluster.Router;
import kd.bos.krpc.rpc.cluster.RouterFactory;
import kd.bos.krpc.rpc.cluster.router.MockInvokersSelector;

public abstract class AbstractDirectory<T>
implements Directory<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDirectory.class);
    private final URL url;
    private volatile boolean destroyed = false;
    private volatile URL consumerUrl;
    private volatile List<Router> routers;

    public AbstractDirectory(URL url) {
        this(url, null);
    }

    public AbstractDirectory(URL url, List<Router> routers) {
        this(url, url, routers);
    }

    public AbstractDirectory(URL url, URL consumerUrl, List<Router> routers) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.url = url;
        this.consumerUrl = consumerUrl;
        this.setRouters(routers);
    }

    @Override
    public List<Invoker<T>> list(Invocation invocation) throws RpcException {
        if (this.destroyed) {
            throw new RpcException("Directory already destroyed .url: " + this.getUrl());
        }
        List<Invoker<T>> invokers = this.doList(invocation);
        List<Router> localRouters = this.routers;
        if (localRouters != null && localRouters.size() > 0) {
            for (Router router : localRouters) {
                try {
                    if (router.getUrl() != null && !router.getUrl().getParameter("runtime", true)) continue;
                    invokers = router.route(invokers, this.getConsumerUrl(), invocation);
                }
                catch (Throwable t) {
                    logger.error("Failed to execute router: " + this.getUrl() + ", cause: " + t.getMessage(), t);
                }
            }
        }
        return invokers;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public List<Router> getRouters() {
        return this.routers;
    }

    public URL getConsumerUrl() {
        return this.consumerUrl;
    }

    public void setConsumerUrl(URL consumerUrl) {
        this.consumerUrl = consumerUrl;
    }

    protected void setRouters(List<Router> routers) {
        routers = routers == null ? new ArrayList<Router>() : new ArrayList<Router>(routers);
        String routerkey = this.url.getParameter("router");
        if (routerkey != null && routerkey.length() > 0) {
            RouterFactory routerFactory = ExtensionLoader.getExtensionLoader(RouterFactory.class).getExtension(routerkey);
            routers.add(routerFactory.getRouter(this.url));
        }
        routers.add(new MockInvokersSelector());
        Collections.sort(routers);
        this.routers = routers;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
    }

    protected abstract List<Invoker<T>> doList(Invocation var1) throws RpcException;
}

