/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.cluster.directory;

import java.util.List;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.cluster.Router;
import kd.bos.krpc.rpc.cluster.directory.AbstractDirectory;

public class StaticDirectory<T>
extends AbstractDirectory<T> {
    private final List<Invoker<T>> invokers;

    public StaticDirectory(List<Invoker<T>> invokers) {
        this(null, invokers, null);
    }

    public StaticDirectory(List<Invoker<T>> invokers, List<Router> routers) {
        this(null, invokers, routers);
    }

    public StaticDirectory(URL url, List<Invoker<T>> invokers) {
        this(url, invokers, null);
    }

    public StaticDirectory(URL url, List<Invoker<T>> invokers, List<Router> routers) {
        super(url == null && invokers != null && invokers.size() > 0 ? invokers.get(0).getUrl() : url, routers);
        if (invokers == null || invokers.size() == 0) {
            throw new IllegalArgumentException("invokers == null");
        }
        this.invokers = invokers;
    }

    @Override
    public Class<T> getInterface() {
        return this.invokers.get(0).getInterface();
    }

    @Override
    public boolean isAvailable() {
        if (this.isDestroyed()) {
            return false;
        }
        for (Invoker<T> invoker : this.invokers) {
            if (!invoker.isAvailable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        super.destroy();
        for (Invoker<T> invoker : this.invokers) {
            invoker.destroy();
        }
        this.invokers.clear();
    }

    @Override
    protected List<Invoker<T>> doList(Invocation invocation) throws RpcException {
        return this.invokers;
    }
}

