/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.cluster.merger;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.common.utils.ReflectUtils;
import kd.bos.krpc.rpc.cluster.Merger;
import kd.bos.krpc.rpc.cluster.merger.ArrayMerger;

public class MergerFactory {
    private static final ConcurrentMap<Class<?>, Merger<?>> mergerCache = new ConcurrentHashMap();

    public static <T> Merger<T> getMerger(Class<T> returnType) {
        Merger result;
        if (returnType.isArray()) {
            Class<?> type = returnType.getComponentType();
            result = (Merger)mergerCache.get(type);
            if (result == null) {
                MergerFactory.loadMergers();
                result = (Merger)mergerCache.get(type);
            }
            if (result == null && !type.isPrimitive()) {
                result = ArrayMerger.INSTANCE;
            }
        } else {
            result = (Merger)mergerCache.get(returnType);
            if (result == null) {
                MergerFactory.loadMergers();
                result = (Merger)mergerCache.get(returnType);
            }
        }
        return result;
    }

    static void loadMergers() {
        Set<String> names = ExtensionLoader.getExtensionLoader(Merger.class).getSupportedExtensions();
        for (String name : names) {
            Merger m = ExtensionLoader.getExtensionLoader(Merger.class).getExtension(name);
            mergerCache.putIfAbsent(ReflectUtils.getGenericClass(m.getClass()), m);
        }
    }
}

