/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.cluster.support;

import java.util.List;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcContext;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.cluster.Directory;
import kd.bos.krpc.rpc.cluster.LoadBalance;
import kd.bos.krpc.rpc.cluster.support.AbstractClusterInvoker;

public class BroadcastClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(BroadcastClusterInvoker.class);

    public BroadcastClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        this.checkInvokers(invokers, invocation);
        RpcContext.getContext().setInvokers(invokers);
        RpcException exception = null;
        Result result = null;
        for (Invoker<?> invoker : invokers) {
            try {
                result = invoker.invoke(invocation);
            }
            catch (RpcException e) {
                exception = e;
                logger.warn(e.getMessage(), e);
            }
            catch (Throwable e) {
                exception = new RpcException(e.getMessage(), e);
                logger.warn(e.getMessage(), e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }
}

