/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.cluster.support.wrapper;

import java.util.List;
import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.RpcInvocation;
import kd.bos.krpc.rpc.RpcResult;
import kd.bos.krpc.rpc.cluster.Directory;
import kd.bos.krpc.rpc.support.MockInvoker;

public class MockClusterInvoker<T>
implements Invoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(MockClusterInvoker.class);
    private final Directory<T> directory;
    private final Invoker<T> invoker;

    public MockClusterInvoker(Directory<T> directory, Invoker<T> invoker) {
        this.directory = directory;
        this.invoker = invoker;
    }

    @Override
    public URL getUrl() {
        return this.directory.getUrl();
    }

    @Override
    public boolean isAvailable() {
        return this.directory.isAvailable();
    }

    @Override
    public void destroy() {
        this.invoker.destroy();
    }

    @Override
    public Class<T> getInterface() {
        return this.directory.getInterface();
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        Result result = null;
        String value = this.directory.getUrl().getMethodParameter(invocation.getMethodName(), "mock", Boolean.FALSE.toString()).trim();
        if (value.length() == 0 || value.equalsIgnoreCase("false")) {
            result = this.invoker.invoke(invocation);
        } else if (value.startsWith("force")) {
            if (logger.isWarnEnabled()) {
                logger.info("force-mock: " + invocation.getMethodName() + " force-mock enabled , url : " + this.directory.getUrl());
            }
            result = this.doMockInvoke(invocation, null);
        } else {
            try {
                result = this.invoker.invoke(invocation);
            }
            catch (RpcException e) {
                if (e.isBiz()) {
                    throw e;
                }
                if (logger.isWarnEnabled()) {
                    logger.info("fail-mock: " + invocation.getMethodName() + " fail-mock enabled , url : " + this.directory.getUrl(), e);
                }
                result = this.doMockInvoke(invocation, e);
            }
        }
        return result;
    }

    private Result doMockInvoke(Invocation invocation, RpcException e) {
        Result result = null;
        List<Invoker<T>> mockInvokers = this.selectMockInvoker(invocation);
        Invoker minvoker = mockInvokers == null || mockInvokers.size() == 0 ? new MockInvoker(this.directory.getUrl()) : mockInvokers.get(0);
        try {
            result = minvoker.invoke(invocation);
        }
        catch (RpcException me) {
            if (me.isBiz()) {
                result = new RpcResult(me.getCause());
            }
            throw new RpcException(me.getCode(), this.getMockExceptionMessage(e, me), me.getCause());
        }
        catch (Throwable me) {
            throw new RpcException(this.getMockExceptionMessage(e, me), me.getCause());
        }
        return result;
    }

    private String getMockExceptionMessage(Throwable t, Throwable mt) {
        String msg = "mock error : " + mt.getMessage();
        if (t != null) {
            msg = msg + ", invoke error is :" + StringUtils.toString(t);
        }
        return msg;
    }

    private List<Invoker<T>> selectMockInvoker(Invocation invocation) {
        if (invocation instanceof RpcInvocation) {
            ((RpcInvocation)invocation).setAttachment("invocation.need.mock", Boolean.TRUE.toString());
            List<Invoker<T>> invokers = this.directory.list(invocation);
            return invokers;
        }
        return null;
    }

    public String toString() {
        return "invoker :" + this.invoker + ",directory: " + this.directory;
    }
}

