/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.filter;

import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.RpcStatus;

@Activate(group={"consumer"}, value={"actives"})
public class ActiveLimitFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        String methodName = invocation.getMethodName();
        int max = invoker.getUrl().getMethodParameter(methodName, "actives", 0);
        RpcStatus count = RpcStatus.getStatus(invoker.getUrl(), invocation.getMethodName());
        if (max > 0) {
            long timeout = invoker.getUrl().getMethodParameter(invocation.getMethodName(), "timeout", 0);
            long start = System.currentTimeMillis();
            long remain = timeout;
            int active = count.getActive();
            if (active >= max) {
                RpcStatus rpcStatus = count;
                synchronized (rpcStatus) {
                    while ((active = count.getActive()) >= max) {
                        long elapsed;
                        try {
                            count.wait(remain);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if ((remain = timeout - (elapsed = System.currentTimeMillis() - start)) > 0L) continue;
                        throw new RpcException("Waiting concurrent invoke timeout in client-side for service:  " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", elapsed: " + elapsed + ", timeout: " + timeout + ". concurrent invokes: " + active + ". max concurrent invoke limit: " + max);
                    }
                }
            }
        }
        try {
            long begin = System.currentTimeMillis();
            RpcStatus.beginCount(url, methodName);
            try {
                Result result = invoker.invoke(invocation);
                RpcStatus.endCount(url, methodName, System.currentTimeMillis() - begin, true);
                Result result2 = result;
                return result2;
            }
            catch (RuntimeException t) {
                RpcStatus.endCount(url, methodName, System.currentTimeMillis() - begin, false);
                throw t;
            }
        }
        finally {
            if (max > 0) {
                RpcStatus rpcStatus = count;
                synchronized (rpcStatus) {
                    count.notify();
                }
            }
        }
    }
}

