/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.filter;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.utils.CompatibleTypeUtils;
import kd.bos.krpc.common.utils.PojoUtils;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.RpcResult;

public class CompatibleFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(CompatibleFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Object value;
        Result result = invoker.invoke(invocation);
        if (!invocation.getMethodName().startsWith("$") && !result.hasException() && (value = result.getValue()) != null) {
            try {
                Object newValue;
                Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                Class<?> type = method.getReturnType();
                String serialization = invoker.getUrl().getParameter("serialization");
                if ("json".equals(serialization) || "fastjson".equals(serialization)) {
                    Type gtype = method.getGenericReturnType();
                    newValue = PojoUtils.realize(value, type, gtype);
                } else {
                    newValue = !type.isInstance(value) ? (PojoUtils.isPojo(type) ? PojoUtils.realize(value, type) : CompatibleTypeUtils.compatibleTypeConvert(value, type)) : value;
                }
                if (newValue != value) {
                    result = new RpcResult(newValue);
                }
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
        }
        return result;
    }
}

