/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.filter;

import java.util.Set;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.common.utils.ConcurrentHashSet;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;

@Activate(group={"consumer"}, value={"deprecated"})
public class DeprecatedFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeprecatedFilter.class);
    private static final Set<String> logged = new ConcurrentHashSet<String>();

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String key = invoker.getInterface().getName() + "." + invocation.getMethodName();
        if (!logged.contains(key)) {
            logged.add(key);
            if (invoker.getUrl().getMethodParameter(invocation.getMethodName(), "deprecated", false)) {
                LOGGER.error("The service method " + invoker.getInterface().getName() + "." + this.getMethodSignature(invocation) + " is DEPRECATED! Declare from " + invoker.getUrl());
            }
        }
        return invoker.invoke(invocation);
    }

    private String getMethodSignature(Invocation invocation) {
        StringBuilder buf = new StringBuilder(invocation.getMethodName());
        buf.append("(");
        Class<?>[] types = invocation.getParameterTypes();
        if (types != null && types.length > 0) {
            boolean first = true;
            for (Class<?> type : types) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(type.getSimpleName());
            }
        }
        buf.append(")");
        return buf.toString();
    }
}

