/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.filter;

import kd.bos.krpc.common.URL;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.RpcStatus;

@Activate(group={"provider"}, value={"executes"})
public class ExecuteLimitFilter
implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcStatus count;
        String methodName;
        URL url = invoker.getUrl();
        int max = url.getMethodParameter(methodName = invocation.getMethodName(), "executes", 0);
        if (max > 0 && (count = RpcStatus.getStatus(url, invocation.getMethodName())).getActive() >= max) {
            throw new RpcException("Failed to invoke method " + invocation.getMethodName() + " in provider " + url + ", cause: The service using threads greater than <dubbo:service executes=\"" + max + "\" /> limited.");
        }
        long begin = System.currentTimeMillis();
        boolean isException = false;
        RpcStatus.beginCount(url, methodName);
        try {
            Result result;
            Result result2 = result = invoker.invoke(invocation);
            return result2;
        }
        catch (Throwable t) {
            isException = true;
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RpcException("unexpected exception when ExecuteLimitFilter", t);
        }
        finally {
            RpcStatus.endCount(url, methodName, System.currentTimeMillis() - begin, isException);
        }
    }
}

