/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.filter;

import java.io.IOException;
import java.lang.reflect.Method;
import kd.bos.krpc.common.beanutil.JavaBeanAccessor;
import kd.bos.krpc.common.beanutil.JavaBeanDescriptor;
import kd.bos.krpc.common.beanutil.JavaBeanSerializeUtil;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.extension.ExtensionLoader;
import kd.bos.krpc.common.io.UnsafeByteArrayInputStream;
import kd.bos.krpc.common.io.UnsafeByteArrayOutputStream;
import kd.bos.krpc.common.serialize.Serialization;
import kd.bos.krpc.common.utils.PojoUtils;
import kd.bos.krpc.common.utils.ReflectUtils;
import kd.bos.krpc.common.utils.StringUtils;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.RpcInvocation;
import kd.bos.krpc.rpc.RpcResult;
import kd.bos.krpc.rpc.service.GenericException;
import kd.bos.krpc.rpc.support.ProtocolUtils;

@Activate(group={"provider"}, order=-20000)
public class GenericFilter
implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws RpcException {
        if (inv.getMethodName().equals("$invoke") && inv.getArguments() != null && inv.getArguments().length == 3 && !ProtocolUtils.isGeneric(invoker.getUrl().getParameter("generic"))) {
            String name = ((String)inv.getArguments()[0]).trim();
            String[] types = (String[])inv.getArguments()[1];
            Object[] args = (Object[])inv.getArguments()[2];
            try {
                int i;
                String generic;
                Method method = ReflectUtils.findMethodByMethodSignature(invoker.getInterface(), name, types);
                Class<?>[] params = method.getParameterTypes();
                if (args == null) {
                    args = new Object[params.length];
                }
                if (StringUtils.isEmpty(generic = inv.getAttachment("generic")) || ProtocolUtils.isDefaultGenericSerialization(generic)) {
                    args = PojoUtils.realize(args, params, method.getGenericParameterTypes());
                } else if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                    for (i = 0; i < args.length; ++i) {
                        if (byte[].class == args[i].getClass()) {
                            try {
                                UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream((byte[])args[i]);
                                args[i] = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("nativejava").deserialize(null, is).readObject();
                                continue;
                            }
                            catch (Exception e) {
                                throw new RpcException("Deserialize argument [" + (i + 1) + "] failed.", (Throwable)e);
                            }
                        }
                        throw new RpcException(new StringBuilder(32).append("Generic serialization [").append("nativejava").append("] only support message type ").append(byte[].class).append(" and your message type is ").append(args[i].getClass()).toString());
                    }
                } else if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                    for (i = 0; i < args.length; ++i) {
                        if (!(args[i] instanceof JavaBeanDescriptor)) {
                            throw new RpcException(new StringBuilder(32).append("Generic serialization [").append("bean").append("] only support message type ").append(JavaBeanDescriptor.class.getName()).append(" and your message type is ").append(args[i].getClass().getName()).toString());
                        }
                        args[i] = JavaBeanSerializeUtil.deserialize((JavaBeanDescriptor)args[i]);
                    }
                }
                Result result = invoker.invoke(new RpcInvocation(method, args, inv.getAttachments()));
                if (result.hasException() && !(result.getException() instanceof GenericException)) {
                    return new RpcResult(new GenericException(result.getException()));
                }
                if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                    try {
                        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream(512);
                        ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("nativejava").serialize(null, os).writeObject(result.getValue());
                        return new RpcResult(os.toByteArray());
                    }
                    catch (IOException e) {
                        throw new RpcException("Serialize result failed.", (Throwable)e);
                    }
                }
                if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                    return new RpcResult(JavaBeanSerializeUtil.serialize(result.getValue(), JavaBeanAccessor.METHOD));
                }
                return new RpcResult(PojoUtils.generalize(result.getValue()));
            }
            catch (NoSuchMethodException e) {
                throw new RpcException(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new RpcException(e.getMessage(), (Throwable)e);
            }
        }
        return invoker.invoke(inv);
    }
}

