/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.filter;

import java.util.Arrays;
import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.common.logger.Logger;
import kd.bos.krpc.common.logger.LoggerFactory;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;

@Activate(group={"provider"})
public class TimeoutFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(TimeoutFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        long start = System.currentTimeMillis();
        Result result = invoker.invoke(invocation);
        long elapsed = System.currentTimeMillis() - start;
        if (invoker.getUrl() != null && elapsed > (long)invoker.getUrl().getMethodParameter(invocation.getMethodName(), "timeout", Integer.MAX_VALUE) && logger.isWarnEnabled()) {
            logger.warn("invoke time out. method: " + invocation.getMethodName() + "arguments: " + Arrays.toString(invocation.getArguments()) + " , url is " + invoker.getUrl() + ", invoke elapsed " + elapsed + " ms.");
        }
        return result;
    }
}

