/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.krpc.rpc.filter;

import kd.bos.krpc.common.extension.Activate;
import kd.bos.krpc.rpc.Filter;
import kd.bos.krpc.rpc.Invocation;
import kd.bos.krpc.rpc.Invoker;
import kd.bos.krpc.rpc.Result;
import kd.bos.krpc.rpc.RpcException;
import kd.bos.krpc.rpc.filter.tps.DefaultTPSLimiter;
import kd.bos.krpc.rpc.filter.tps.TPSLimiter;

@Activate(group={"provider"}, value={"tps"})
public class TpsLimitFilter
implements Filter {
    private final TPSLimiter tpsLimiter = new DefaultTPSLimiter();

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (!this.tpsLimiter.isAllowable(invoker.getUrl(), invocation)) {
            throw new RpcException(new StringBuilder(64).append("Failed to invoke service ").append(invoker.getInterface().getName()).append(".").append(invocation.getMethodName()).append(" because exceed max service tps.").toString());
        }
        return invoker.invoke(invocation);
    }
}

